Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Constructions.Transforms.Product.
Require Import Metarouting.IsoPres.DecSetoids.Product.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' y y' : Transform), DsIso x x' -> DsIso y y' ->
      DsIso (prodTransform x y) (prodTransform x' y').
   Proof. intros x x' y y' i i'.
      destruct x; destruct y; destruct x'; destruct y'; simpl in *.
      apply Product.isoPres; auto.
   Defined.

   Lemma isoPres_helper_2 : forall (x x' y y' : Transform), DsIso (fn x) (fn x') -> DsIso (fn y) (fn y') ->
      DsIso (fn (prodTransform x y)) (fn (prodTransform x' y')).
   Proof. intros x x' y y' i i'.
      destruct x; destruct y; destruct x'; destruct y'; simpl in *.
      apply Product.isoPres; auto.
   Defined.

   Lemma isoPres : forall (x x' y y' : Transform), TfIso x x' -> TfIso y y' ->
      TfIso (prodTransform x y) (prodTransform x' y').
   Proof. intros x x' y y' i i'.
      set (X := x); set (X' := x'); set (ISO := i);
      set (Y := y); set (Y' := y'); set (ISO' := i');
      apply (Build_TfIso) with (isoPres_helper x x' y y' i i') (isoPres_helper_2 x x' y y' (fnIso i) (fnIso i')).
      split; simpl; intros [a1 a2] [b1 b2]; unfold isoPres_helper; simpl; unfold prod_app; dseq_f; auto;
      destruct x; destruct x'; destruct y; destruct y'; dseq_u; simpl in *; toProp; dseq_f; split.
      
      apply (pres_app i).
      apply (pres_app i').
      apply (pres_app' i).
      apply (pres_app' i').
   Defined.

   Lemma idPres : forall (x x' y y' : Transform), IdTfIso x x' -> IdTfIso y y' ->
      IdTfIso (prodTransform x y) (prodTransform x' y').
   Proof. intros x x' y y' i i'; split with (isoPres x x' y y' i i'); split;
      destruct i as [[[phi1 phi1'] [fphi1 fphi1']] [ip1 ip1'] [fip1 fip1']]; simpl in *;
      destruct i' as [[[phi2 phi2'] [fphi2 fphi2']] [ip2 ip2'] [fip2 fip2']]; simpl in *;
      destruct x; destruct x'; destruct y; destruct y'; simpl in *.
      
      clear - ip1 ip2; destruct ip1; destruct ip2; split; intros [x1 x2]; rewrite (H x1), (H0 x2); auto.
      clear - ip1' ip2'; destruct ip1'; destruct ip2'; split; intros [x1 x2]; rewrite (H x1), (H0 x2); auto.
      clear - fip1 fip2; destruct fip1; destruct fip2; split; intros [x1 x2]; rewrite (H x1), (H0 x2); auto.
      clear - fip1' fip2'; destruct fip1'; destruct fip2'; split; intros [x1 x2]; rewrite (H x1), (H0 x2); auto.
   Defined.

End IsoPres.

