Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Constructions.Transforms.Id.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' : DecSetoid), DsIso x x' ->
      DsIso (idTransform x) (idTransform x').
   Proof. intros x x' i. apply i. Defined.

   Lemma isoPres : forall (x x' : DecSetoid), DsIso x x' ->
      TfIso (idTransform x) (idTransform x').
   Proof. intros x x' i.
      apply (Build_TfIso) with (isoPres_helper x x' i) (DsIso_refl _).
      split; simpl; intros a b; unfold isoPres_helper; simpl; unfold id_app; dseq_f; auto.
   Defined.

   Lemma idPres : forall (x x' : DecSetoid), IdDsIso x x' ->
      IdTfIso (idTransform x) (idTransform x').
   Proof. intros x x' i; split with (isoPres x x' i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *; auto; split; intros x; auto.
   Defined.

End IsoPres.
