Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Constructions.Transforms.Cayley.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres : forall (x x' : Semigroup), SmgIso x x' ->
      TfIso (cayleyMapTransform x) (cayleyMapTransform x').
   Proof. intros x x' i.
      apply (Build_TfIso) with (Semigroup.dsIso i) (Semigroup.dsIso i).
      split; simpl; intros a b; simpl; unfold cayley_app; dseq_f.
      apply (pres_op i).
      apply (pres_op' i).
   Defined.

   Lemma idPres : forall (x x' : Semigroup), IdSmgIso x x' ->
      IdTfIso (cayleyMapTransform x) (cayleyMapTransform x').
   Proof. intros x x' i; split with (isoPres x x' i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *; auto.
   Defined.

End IsoPres.
