Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Constructions.Semigroups.SimpleSeq.
Require Import Metarouting.IsoPres.Semigroups.Seq.
Require Import Metarouting.IsoPres.DecSetoids.SimpleSeq.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' : DecSetoid), DsIso x x' ->
      DsIso (simpleSeqSemigroup x) (simpleSeqSemigroup x').
   Proof. intros x x' i; apply (SimpleSeq.isoPres _ _ i). Defined.

   Lemma isoPres : forall (x x' : DecSetoid), DsIso x x' ->
      SmgIso (simpleSeqSemigroup x) (simpleSeqSemigroup x').
   Proof. intros x x' i;
      set (X := x); set (X' := x'); set (ISO := i);
      apply (Build_SmgIso) with (isoPres_helper x x' i).
      split; simpl; intros a b; unfold isoPres_helper; simpl;
      (*destruct x; destruct x'; destruct i; simpl;*)
      rewrite map_app; auto.
   Defined.

   Lemma idPres : forall (x x' : DecSetoid), IdDsIso x x' ->
      IdSmgIso (simpleSeqSemigroup x) (simpleSeqSemigroup x').
   Proof. intros x x' i; split with (isoPres x x' i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *.
      
      clear -ip1; destruct ip1; split; intros l; induction l; auto; simpl;
      rewrite IHl, (H a); auto.

      clear -ip1'; destruct ip1'; split; intros l; induction l; auto; simpl;
      rewrite IHl, (H a); auto.
   Defined.

End IsoPres.
