Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Constructions.Semigroups.Right.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres : forall x x', DsIso x x' -> SmgIso (rightSemigroup x) (rightSemigroup x').
   Proof. intros x x' i. set (X := x); set (X' := x'); set (ISO := i);
      set (iso := i).
      apply (Build_SmgIso) with i.
      split; simpl; unfold right_op; simpl; intros; auto.
   Defined.

   Lemma idPres : forall x x', IdDsIso x x' -> IdSmgIso (rightSemigroup x) (rightSemigroup x').
   Proof. intros x x' i; split with (isoPres x x' i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *; auto.
   Defined.

End IsoPres.