Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Constructions.Semigroups.RevOp.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres_helper : forall (x y : Semigroup), DsIso x y ->
      DsIso (revOpSemigroup x) (revOpSemigroup y).
   Proof. intros x y i; apply i. Defined.

   Lemma isoPres : forall x x', SmgIso x x' -> SmgIso (revOpSemigroup x) (revOpSemigroup x').
   Proof. intros x x' i. 
      apply (Build_SmgIso) with (isoPres_helper x x' i).
      split.
      intros a b; simpl; unfold rev_op; auto. destruct i; simpl; auto.
      unfold isoPres_helper; simpl. destruct isSmgIso; auto.
      intros a b; simpl; unfold rev_op; auto. destruct i; simpl; auto.
      unfold isoPres_helper; simpl. destruct isSmgIso; auto.
   Defined.

   Lemma idPres : forall x x', IdSmgIso x x' -> IdSmgIso (revOpSemigroup x) (revOpSemigroup x').
   Proof. intros x x' i;
      split with (isoPres x x' i); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *; auto.
   Defined.

End IsoPres.
