Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Constructions.DecSetoids.MultiSets.
Require Import Metarouting.Constructions.Semigroups.MultiSetsUnion.
Require Import Metarouting.IsoPres.DecSetoids.MultiSets.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Ltac toCount :=
      repeat rewrite multieq_count in *;
      repeat rewrite app_count in *.

   Ltac toCount_u :=
      dseq_u; simpl; toCount.

   Lemma isoPres : forall x x', DsIso x x' -> SmgIso (multisetUnionSemigroup x) (multisetUnionSemigroup x').
   Proof. intros x x' i.
      split with (MultiSets.isoPres _ _ i).
      split.
      intros s s'. toCount_u. intros a; toCount. rewrite map_app; toCount; auto.
      intros s s'. toCount_u. intros a; toCount. rewrite map_app; toCount; auto.
   Defined.

   Lemma idPres : forall x x', IdDsIso x x' -> IdSmgIso (multisetUnionSemigroup x) (multisetUnionSemigroup x').
   Proof. intros x x' i; split with (isoPres x x' i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *; apply IsId_map; auto.
   Defined.

End IsoPres.