Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.Semigroups.FSetsUnion.
Require Import Metarouting.IsoPres.DecSetoids.FSets.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section IsoPres.


   Lemma isoPres_helper : forall x x', DsIso x x' ->
      DsIso (fsetsUnionSemigroup x) (fsetsUnionSemigroup x').
   Proof. intros x x' i; destruct x; destruct x'; simpl.
      apply FSets.isoPres. apply i.
   Defined.

   Lemma phi_nodub : forall {D D'} (i : DsIso D D') a y, mem a (map (phi i) (nodub D y)) = mem a (map (phi i) y).
   Proof. intros.
      repeat rewrite <- (mem_phi i).
      apply nodub_mem.
   Qed.

   Lemma phi_nodub' : forall {D D'} (i : DsIso D D') a y, mem a (map (phi' i) (nodub D' y)) = mem a (map (phi' i) y).
   Proof. intros.
      repeat rewrite <- (mem_phi' i).
      apply nodub_mem.
   Qed.

   Lemma phi_union : forall {D D'} (i : DsIso D D') x y a, 
                mem a (map (phi i) (union D x y)) = mem a (map (phi i) x) || mem a (map (phi i) y).
   Proof. intros D D' i x y a.
      unfold union. rewrite phi_nodub.
      induction x. trivial.
      simpl. rewrite IHx, orb_assoc; auto.
   Defined.

   Lemma phi_union' : forall {D D'} (i : DsIso D D') x y a, 
                mem a (map (phi' i) (union D' x y)) = mem a (map (phi' i) x) || mem a (map (phi' i) y).
   Proof. intros D D' i x y a.
      unfold union. rewrite phi_nodub'.
      induction x. trivial.
      simpl. rewrite IHx, orb_assoc; auto.
   Defined.

   Lemma isoPres : forall x x', DsIso x x' -> SmgIso (fsetsUnionSemigroup x) (fsetsUnionSemigroup x').
   Proof. intros x x' i. set (X := x); set (X' := x'); set (ISO := i);
      set (iso := i);
      apply (Build_SmgIso) with (isoPres_helper x x' i).
      split; simpl; intros a b; unfold isoPres_helper; simpl;
      destruct x; destruct x'; destruct i; simpl;
      toSet_u; simpl.
      apply (phi_union ISO).
      apply (phi_union' ISO).
   Defined.

   Lemma idPres : forall x x', IdDsIso x x' -> IdSmgIso (fsetsUnionSemigroup x) (fsetsUnionSemigroup x').
   Proof. intros x x' i; split with (isoPres x x' i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *; apply IsId_map; auto.
   Defined.

End IsoPres.