Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.Semigroups.FSetsIntersect.
Require Import Metarouting.IsoPres.DecSetoids.FSets.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section IsoPres.


   Lemma isoPres_helper : forall x x', DsIso x x' ->
      DsIso (fsetsIntersectionSemigroup x) (fsetsIntersectionSemigroup x').
   Proof. intros x x' i; destruct x; destruct x'; simpl.
      apply FSets.isoPres. apply i.
   Defined.

   Lemma phi_intersect : forall {D D'} (i : DsIso D D') x y a, 
                mem a (map (phi i) (intersect D x y)) = mem a (map (phi i) x) && mem a (map (phi i) y).
   Proof. intros D D' i x y a.
      unfold intersect.
      induction x. trivial.
      simpl.
      copy_destruct (mem a0 y); rewrite ew; simpl; rewrite IHx; auto.

      copy_destruct (mem a (map (phi i) y)); rewrite ew0, ?andb_false_r, ?andb_true_r; auto.
      rewrite orb_false_r. bool_p.
      intros h; elim ew0. dseq_f.
      rewrite (mem_pres_eq _ h).
      rewrite <- mem_phi.
      assert (phi' i (phi i a0) == a0).
         rewrite (inv' i); auto.
      rewrite (mem_pres_eq _ H); auto.
      
      copy_destruct (mem a (map (phi i) x)); rewrite ew0, ?orb_true_r, ?orb_false_r; auto.
      copy_destruct (mem a (map (phi i) y)); rewrite ew1, ?andb_true_r, ?andb_false_r; auto.
      apply sym_equal; bool_p. intros h; elim ew; dseq_f.
      assert (p := pres_eq' (x:=a) (y:= phi i a0) i h).
      rewrite (inv' i) in p.
      rewrite <- (mem_pres_eq y p).
      rewrite mem_phi; auto.
   Defined.
   
   Lemma phi_intersect' : forall {D D'} (i : DsIso D D') x y a, 
                mem a (map (phi' i) (intersect D' x y)) = mem a (map (phi' i) x) && mem a (map (phi' i) y).
   Proof. intros D D' i x y a.
      unfold intersect.
      induction x. trivial.
      simpl.
      copy_destruct (mem a0 y); rewrite ew; simpl; rewrite IHx; auto.

      copy_destruct (mem a (map (phi' i) y)); rewrite ew0, ?andb_false_r, ?andb_true_r; auto.
      rewrite orb_false_r. bool_p.
      intros h; elim ew0. dseq_f.
      rewrite (mem_pres_eq _ h).
      rewrite <- mem_phi'.
      assert (phi i (phi' i a0) == a0).
         rewrite (inv i); auto.
      rewrite (mem_pres_eq _ H); auto.
      
      copy_destruct (mem a (map (phi' i) x)); rewrite ew0, ?orb_true_r, ?orb_false_r; auto.
      copy_destruct (mem a (map (phi' i) y)); rewrite ew1, ?andb_true_r, ?andb_false_r; auto.
      apply sym_equal; bool_p. intros h; elim ew; dseq_f.
      assert (p := pres_eq (x:=a) (y:= phi' i a0) i h).
      rewrite (inv i) in p.
      rewrite <- (mem_pres_eq y p).
      rewrite mem_phi'; auto.
   Defined.

   Lemma isoPres : forall x x', DsIso x x' -> SmgIso (fsetsIntersectionSemigroup x) (fsetsIntersectionSemigroup x').
   Proof. intros x x' i. set (X := x); set (X' := x'); set (ISO := i);
      set (iso := i);
      apply (Build_SmgIso) with (isoPres_helper x x' i).
      split; simpl; intros a b; unfold isoPres_helper; simpl;
      destruct x; destruct x'; destruct i; simpl;
      toSet_u; simpl.
      apply (phi_intersect ISO).
      apply (phi_intersect' ISO).
   Defined.

   Lemma idPres : forall x x', IdDsIso x x' -> IdSmgIso (fsetsIntersectionSemigroup x) (fsetsIntersectionSemigroup x').
   Proof. intros x x' i; split with (isoPres x x' i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *; apply IsId_map; auto.
   Defined.

End IsoPres.