Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.DecSetoids.FMinSets.
Require Import Metarouting.Constructions.Semigroups.FSetsUnion.
Require Import Metarouting.Constructions.Semigroups.FMinSetsUnion.
Require Import Metarouting.IsoPres.DecSetoids.FSets.
Require Import Metarouting.IsoPres.DecSetoids.FMinSets.
Require Import Metarouting.IsoPres.Semigroups.FSetsUnion.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section IsoPres.


   Lemma isoPres_helper : forall (x x' : Preorder), ProIso x x' ->
      DsIso (msetUnionSemigroup x) (msetUnionSemigroup x').
   Proof. intros x x' i; destruct x; destruct x'; simpl.
      apply FMinSets.isoPres. apply i.
   Defined.

   Lemma isoPres : forall x x', ProIso x x' -> SmgIso (msetUnionSemigroup x) (msetUnionSemigroup x').
   Proof. intros x x' i. set (X := x); set (X' := x'); set (ISO := i);
      set (iso := i);
      apply (Build_SmgIso) with (isoPres_helper x x' i).
      split; simpl; intros a b; unfold isoPres_helper; simpl;
      destruct x; destruct x'; destruct i; simpl;
      dseq_u; simpl; unfold eq_mset; dseq_f; simpl; unfold mset_union.

      apply (min_pres_eq X'). 
      toSet_u; simpl.
      rewrite <- (mem_phi ISO), (min_phi ISO); apply min_pres_eq_mem;
      intros w; simpl; rewrite phi_union, union_mem; auto.

      apply (min_pres_eq X). 
      toSet_u; simpl.
      rewrite <- (mem_phi' ISO), (min_phi' ISO); apply min_pres_eq_mem;
      intros w; simpl; rewrite phi_union', union_mem; auto.
   Defined.

   Lemma idPres : forall x x', IdProIso x x' -> IdSmgIso (msetUnionSemigroup x) (msetUnionSemigroup x').
   Proof. intros x x' i. split with (isoPres x x' i); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *; apply IsId_map; auto.
   Defined.

End IsoPres.
