Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.DecSetoids.FMinSets.
Require Import Metarouting.Constructions.Semigroups.FSetOp.
Require Import Metarouting.Constructions.Semigroups.FMinSetsOp.
Require Import Metarouting.IsoPres.DecSetoids.FMinSets.
Require Import Metarouting.IsoPres.Semigroups.FSetOp.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Lists.List.

Section IsoPres.

   Lemma isoPres_helper : forall x x', OSmgIso x x' -> forall lmon rmon asm lmon' rmon' asm', 
                                                DsIso (msetOpSemigroup x lmon rmon asm) (msetOpSemigroup x' lmon' rmon' asm').
   Proof. intros x x' i lmon rmon asm lmon' rmon' asm'; destruct x; destruct x'; simpl.
      apply FMinSets.isoPres; apply (ProOSmgIso i).
   Defined.

   Lemma isoPres : forall x x', OSmgIso x x' -> forall lmon rmon asm lmon' rmon' asm', 
                                                SmgIso (msetOpSemigroup x lmon rmon asm) (msetOpSemigroup x' lmon' rmon' asm').
   Proof. intros x x' i lmon rmon asm lmon' rmon' asm'.
      set (X := x);
      set (X' := x');
      set (ISO := i).

      apply (Build_SmgIso) with (isoPres_helper x x' i lmon rmon asm lmon' rmon' asm').
      split; simpl; unfold mset_op; intros a b; dseq_u; simpl; unfold eq_mset;
      apply min_pres_eq; toSet_u; unfold isoPres_helper; simpl;
      destruct x; destruct x'; simpl.
      
      rewrite <- (mem_phi i), (min_phi i);
      apply (min_pres_eq_mem (Preorder.Build_Preorder le_refl0 le_trans0 le_pres_eq0));
      assert (q := phi_fset_op X X' (SmgOSmgIso ISO) a b);
      unfold ISO in q; simpl in q.
      dseq_u; simpl in q;
      rewrite eq_fset_mem in q;
      intros x; rewrite q. auto.

      rewrite <- (mem_phi' i), (min_phi' i).
      apply (min_pres_eq_mem (Preorder.Build_Preorder le_refl le_trans le_pres_eq));
      assert (q := phi_fset_op' X X' (SmgOSmgIso ISO) a b);
      unfold ISO in q; simpl in q.
      dseq_u; simpl in q;
      rewrite eq_fset_mem in q;
      intros x; rewrite q. auto.
   Defined.

   Lemma idPres : forall x x', IdOSmgIso x x' -> forall lmon rmon asm lmon' rmon' asm', 
                                                IdSmgIso (msetOpSemigroup x lmon rmon asm) (msetOpSemigroup x' lmon' rmon' asm').
   Proof. intros x x' i lmon rmon asm lmon' rmon' asm'; split with (isoPres x x' i lmon rmon asm lmon' rmon' asm'); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *; apply IsId_map; auto.
   Defined.

End IsoPres.