Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Constructions.SemigroupTransforms.Lex.
Require Import Metarouting.IsoPres.Semigroups.Lex.
Require Import Metarouting.IsoPres.Transforms.Product.
Require Import Metarouting.IsoPres.SemigroupTransforms.Glue.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.

Section IsoPres.

   Lemma isoPres : forall (x x' y y' : SemigroupTransform) comm idem hasId comm' idem' hasId', STfIso x x' -> STfIso y y' ->
      STfIso (lexSemigroupTransform x y comm idem hasId) (lexSemigroupTransform x' y' comm' idem' hasId').
   Proof. intros x x' y y' comm idem hasId comm' idem' hasId' i i';
      set (X := x); set (X' := x'); set (Y := y); set (Y' := y').
      
      apply Glue.isoPres.

      destruct x; destruct x'; destruct setoid; destruct setoid0; 
      destruct y; destruct y'; destruct setoid; destruct setoid0; 
      simpl in *.
      
      split with (Lex.isoPres _ _ _ _ i i' comm idem hasId comm' idem' hasId')
                 (Transform.fnIso (Product.isoPres _ _ _ _ i i')).
      apply (isTfIso (IsoPres.Transforms.Product.isoPres _ _ _ _ i i')).
   Defined.

   Lemma idPres : forall (x x' y y' : SemigroupTransform) comm idem hasId comm' idem' hasId', 
      IdSTfIso x x' -> IdSTfIso y y' ->
      IdSTfIso (lexSemigroupTransform x y comm idem hasId) (lexSemigroupTransform x' y' comm' idem' hasId').
   Proof.  intros x x' y y' comm idem hasId comm' idem' hasId' i i'.
      split with (isoPres x x' y y' comm idem hasId comm' idem' hasId' i i'); split;
      destruct i as [[[phi1 phi1'] [fphi1 fphi1']] [ip1 ip1'] [fip1 fip1']]; simpl in *;
      destruct i' as [[[phi2 phi2'] [fphi2 fphi2']] [ip2 ip2'] [fip2 fip2']]; simpl in *;
      destruct x; destruct x'; destruct setoid; destruct setoid0;
      destruct y; destruct y'; destruct setoid; destruct setoid0;
      simpl in *; auto.

      destruct ip1; destruct ip2; split; intros [x y]; simpl; rewrite (H x), (H0 y); auto.
      destruct ip1'; destruct ip2'; split; intros [x y]; simpl; rewrite (H x), (H0 y); auto.
      clear - fip1 fip2; destruct fip1; destruct fip2; split; intros [x y]; simpl; rewrite (H x), (H0 y); auto.
      clear - fip1' fip2'; destruct fip1'; destruct fip2'; split; intros [x y]; simpl; rewrite (H x), (H0 y); auto.
   Defined.

End IsoPres.

