Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Constructions.Preorders.Lex.
Require Import Metarouting.IsoPres.DecSetoids.Product.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres : forall (x x' y y' : Preorder), ProIso x x' -> ProIso y y' ->
         ProIso (lexPreorder x y) (lexPreorder x' y').
   Proof. intros x x' y y' i i'.
      split with (IsoPres.DecSetoids.Product.isoPres _ _ _ _ i i');
      split; simpl; unfold lex_le; intros [x1 x2] [y1 y2]; simpl; toProp;
      intros [p1 [p2 | p2]]; split.

      apply (pres_le i); auto.
      apply or_introl; intros h; elim p2; assert (h2 := pres_le' i _ _ h); do 2 rewrite (inv' i) in h2; auto.

      apply (pres_le i); auto.
      apply or_intror; apply (pres_le i'); auto.
         
      apply (pres_le' i); auto.
      apply or_introl; intros h; elim p2; assert (h2 := pres_le i _ _ h); do 2 rewrite (inv i) in h2; auto.

      apply (pres_le' i); auto.
      apply or_intror; apply (pres_le' i'); auto.
   Defined.

   Lemma idPres : forall (x x' y y' : Preorder), IdProIso x x' -> IdProIso y y' ->
         IdProIso (lexPreorder x y) (lexPreorder x' y').
   Proof. intros x x' y y' i i'; split with (isoPres x x' y y' i i'); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct i' as [[[phi2 phi2']] [ip2 ip2']]; simpl in *;
      destruct x; destruct x'; destruct y; destruct y'; simpl in *; auto.
      
      clear - ip1 ip2; destruct ip1; destruct ip2; split; intros [x1 x2]; rewrite (H x1), (H0 x2); auto.
      clear - ip1' ip2'; destruct ip1'; destruct ip2'; split; intros [x1 x2]; rewrite (H x1), (H0 x2); auto.
   Defined.

End IsoPres.
