Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Constructions.Preorders.Dual.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' : Preorder), DsIso x x' ->
      DsIso (dualPreorder x) (dualPreorder x').
   Proof. intros x x' i. apply i. Defined.

   Lemma isoPres : forall (x x' : Preorder), ProIso x x' ->
      ProIso (dualPreorder x) (dualPreorder x').
   Proof. intros x x' i;
      set (X := x); set (X' := x'); set (ISO := i);
      apply (Build_ProIso) with (isoPres_helper x x' i).
      split; simpl; intros a b; unfold isoPres_helper; simpl; unfold ge.
      apply (pres_le i).
      apply (pres_le' i).
   Defined.

   Lemma idPres : forall (x x' : Preorder), IdProIso x x' ->
      IdProIso (dualPreorder x) (dualPreorder x').
   Proof. intros x x' i; split with (isoPres x x' i); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *; auto.
   Defined.

End IsoPres.
