Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Constructions.Preorders.LeftNaturalOrder.
Require Import Metarouting.Constructions.OrderSemigroups.LeftNaturalOrder.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' : Semigroup) idem idem', SmgIso x x' ->
      DsIso (leftNaturalOrder x idem) (leftNaturalOrder x' idem').
   Proof. intros x x' idem idem' i. destruct x; destruct x'; 
      destruct setoid; destruct setoid0; simpl in *. apply i.
   Defined.

   Lemma isoPres : forall (x x' : Semigroup) idem idem', SmgIso x x' ->
      OSmgIso (leftNaturalOrder x idem) (leftNaturalOrder x' idem').
   Proof. intros x x' idem idem' i. split with (isoPres_helper x x' idem idem' i).
      destruct x; destruct x'; 
      destruct setoid; destruct setoid0; simpl in *. destruct i; split; simpl in *.
      
      apply (Semigroup.pres_op isSmgIso).
      apply (Semigroup.pres_op' isSmgIso).
      intros x y; unfold le; dseq_f; intros p; rewrite <- (Semigroup.pres_op isSmgIso), p; auto.
      intros x y; unfold le; dseq_f; intros p; rewrite <- (Semigroup.pres_op' isSmgIso), p; auto.
   Defined.

   Lemma idPres : forall (x x' : Semigroup) idem idem', IdSmgIso x x' ->
      IdOSmgIso (leftNaturalOrder x idem) (leftNaturalOrder x' idem').
   Proof. intros x x' idem idem' i; split with (isoPres x x' idem idem' i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; destruct setoid; destruct setoid0; simpl in *; auto.
   Defined.

End IsoPres.
