Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Constructions.DecSetoids.Union.
Require Import Metarouting.Signatures.IdArrow.

Section IsoPres.

   Lemma isoPres : forall x y x' y', DsIso x y -> DsIso x' y' -> DsIso (unionDecSetoid x x') (unionDecSetoid y y').
   Proof. intros x y x' y' i i'.
      apply (@Build_DsIso (unionDecSetoid x x') (unionDecSetoid y y')
         (fun a => match a with 
            | inl a => inl _ (phi i a) 
            | inr a => inr _ (phi i' a) 
          end)
         (fun a => match a with 
            | inl a => inl _ (phi' i a) 
            | inr a => inr _ (phi' i' a) 
          end)).
      split.
      intros [a1|a2] [b1|b2]; dseq_u; simpl; intros e; auto.
         apply (pres_eq i); auto.
         apply (pres_eq i'); auto.
      intros [a1|a2] [b1|b2]; dseq_u; simpl; intros e; auto.
         apply (pres_eq' i); auto.
         apply (pres_eq' i'); auto.
      intros [a1|a2]; dseq_u; simpl; auto.
         apply (inv i); auto.
         apply (inv i'); auto.
      intros [a1|a2]; dseq_u; simpl; auto.
         apply (inv' i); auto.
         apply (inv' i'); auto.
   Defined.
   
   Lemma idPres : forall x y x' y', IdDsIso x y -> IdDsIso x' y' -> IdDsIso (unionDecSetoid x x') (unionDecSetoid y y').
   Proof. intros x y x' y' i i'. split with (isoPres x y x' y' i i'); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *;
      destruct i' as [[phi2 phi2'] [ip2 ip2']]; simpl in *.
      
      clear - ip1 ip2; destruct ip1; destruct ip2. 
      split; intros [a|a]; [rewrite (H a) | rewrite (H0 a)]; auto.

      clear - ip1' ip2'; destruct ip1'; destruct ip2';
      split; intros [a|a]; [rewrite (H a) | rewrite (H0 a)]; auto.
   Defined.

End IsoPres.