Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Constructions.DecSetoids.MultiSets.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Lists.List.

Section IsoPres.

   Ltac toCount :=
      repeat rewrite multieq_count in *.

   Ltac toCount_u :=
      dseq_u; simpl; toCount.

   Lemma count_phi : forall x y (i : DsIso x y) a s, count y a (map (phi i) s) = count x (phi' i a) s.
   Proof. intros.
      induction s; trivial.
      simpl.
      assert ((a == phi i a0)%bool = (phi' i a == a0)%bool) as q; [|rewrite q].
         rewrite bool_eq; split; dseq_f; rewrite isoMove; auto.
      destruct ((phi' i a == a0)%bool); auto.
   Qed.

   Lemma count_phi' : forall x y (i : DsIso x y) a s, count x a (map (phi' i) s) = count y (phi i a) s.
   Proof. intros.
      induction s; trivial.
      simpl.
      assert ((a == phi' i a0)%bool = (phi i a == a0)%bool) as q; [|rewrite q].
         rewrite bool_eq; split; dseq_f; rewrite isoMove'; auto.
      destruct ((phi i a == a0)%bool); auto.
   Qed.

   Lemma isoPres : forall x y, DsIso x y -> DsIso (multisetDecSetoid x) (multisetDecSetoid y).
   Proof. intros x y i.
      apply (@Build_DsIso (multisetDecSetoid x) (multisetDecSetoid y)
         (map (phi i))
         (map (phi' i))).
      split.
      
      intros s s'; toCount_u. intros p a. repeat rewrite count_phi; apply p.
      intros s s'; toCount_u. intros p a. repeat rewrite count_phi'; apply p.
      intros s; toCount_u. intros a. rewrite count_phi, count_phi'.
      rewrite (@count_pres_eq _ a (phi i (phi' i a))); auto.
      rewrite (inv i); auto.
      intros s; toCount_u. intros a. rewrite count_phi', count_phi.
      rewrite (@count_pres_eq _ a (phi' i (phi i a))); auto.
      rewrite (inv' i); auto.
   Defined.

   Lemma idPres : forall x y, IdDsIso x y -> IdDsIso (multisetDecSetoid x) (multisetDecSetoid y).
   Proof. intros x y i; split with (isoPres x y i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *; apply IsId_map; auto.
   Defined.

End IsoPres.