Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Lists.List.

Section IsoPres.

   Lemma mem_phi : forall {A} {B} (i : DsIso A B) r c, mem (phi' i r) c = mem r (map (phi i) c).
   Proof. intros A B i r c.
      induction c. trivial.
      simpl. rewrite bool_eq; split; toProp; intros [h|h]; dseq_f.
         apply or_introl; rewrite <-h; rewrite (inv i); auto.
         rewrite IHc in h; auto.
         apply or_introl; rewrite h; rewrite (inv' i); auto.
         rewrite <- IHc in h; auto.
   Qed.

   Lemma mem_phi' : forall {A} {B} (i : DsIso A B) r c, mem (phi i r) c = mem r (map (phi' i) c).
   Proof. intros A B i r c.
      induction c. trivial.
      simpl. rewrite bool_eq; split; toProp; intros [h|h]; dseq_f.
         apply or_introl; rewrite <-h; rewrite (inv' i); auto.
         rewrite IHc in h; auto.
         apply or_introl; rewrite h; rewrite (inv i); auto.
         rewrite <- IHc in h; auto.
   Qed.

   Lemma isoPres : forall x y, DsIso x y -> DsIso (fsetDecSetoid x) (fsetDecSetoid y).
   Proof. intros x y i.
      apply (@Build_DsIso (fsetDecSetoid x) (fsetDecSetoid y)
         (map (phi i))
         (map (phi' i))).
      split.
      intros a b e.
         dseq_u; simpl in *; rewrite eq_fset_mem in *; intros w; do 2 rewrite <- (mem_phi i); auto.
      intros a b e.
         dseq_u; simpl in *; rewrite eq_fset_mem in *; intros w; do 2 rewrite <- (mem_phi' i); auto.
      intros a.
         dseq_u; simpl in *; rewrite eq_fset_mem in *; intros w.
         rewrite <- (mem_phi i), <- (mem_phi' i); 
         rewrite (mem_pres_eq _ (inv i w)); auto.
      intros a.
         dseq_u; simpl in *; rewrite eq_fset_mem in *; intros w.
         rewrite <- (mem_phi' i), <- (mem_phi i); 
         rewrite (mem_pres_eq _ (inv' i w)); auto.
   Defined.

   Lemma idPres : forall x y, IdDsIso x y -> IdDsIso (fsetDecSetoid x) (fsetDecSetoid y).
   Proof. intros x y i; split with (isoPres x y i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *; apply IsId_map; auto.
   Defined.

End IsoPres.