Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.DecSetoids.FMinSets.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Lists.List.

Section IsoPres.

   Lemma min_pres_eq_mem : forall P a b, (forall x, mem x a = mem x b) -> forall x, mem x (min P a) = mem x (min P b).
   Proof. intros P a b h.
      rewrite <- eq_fset_mem.
      assert (q := @min_pres_eq P a b); dseq_u; simpl in q.
      apply q; rewrite eq_fset_mem; auto.
   Qed.

   Lemma mem_phi : forall {A} {B} (i : ProIso A B) r c, mem (phi' i r) c = mem r (map (phi i) c).
   Proof. intros A B i r c.
      induction c. trivial.
      simpl. rewrite bool_eq; split; toProp; intros [h|h]; dseq_f.
         apply or_introl; rewrite <-h; rewrite (inv i); auto.
         rewrite IHc in h; auto.
         apply or_introl; rewrite h; rewrite (inv' i); auto.
         rewrite <- IHc in h; auto.
   Qed.

   Lemma mem_phi' : forall {A} {B} (i : ProIso A B) r c, mem (phi i r) c = mem r (map (phi' i) c).
   Proof. intros A B i r c.
      induction c. trivial.
      simpl. rewrite bool_eq; split; toProp; intros [h|h]; dseq_f.
         apply or_introl; rewrite <-h; rewrite (inv' i); auto.
         rewrite IHc in h; auto.
         apply or_introl; rewrite h; rewrite (inv i); auto.
         rewrite <- IHc in h; auto.
   Qed.
   
   Lemma min_phi : forall {A} {B} (i : ProIso A B) r c, mem (phi' i r) (min A c) = mem r (min B (map (phi i) c)).
   Proof. intros A B i r c.
      rewrite bool_eq; split; intros h.
      rewrite min_mem in h. destruct h as [p q].
      rewrite min_mem. split.
      rewrite <- (mem_phi i); auto.
      intros w h. rewrite <- (mem_phi i) in h.
      assert (m := q _ h). toProp; intros [t1 t2]; elim m; split.
      apply (pres_le' i); auto.
      intros t; elim t2.
      rewrite <- (inv i r), <- (inv i w); apply (pres_le i); auto.
      rewrite min_mem in h; destruct h as [p q];
      rewrite min_mem; split.
      rewrite (mem_phi i); auto.
      intros w h.
      rewrite <- (mem_pres_eq c (inv' i w)) in h.
      rewrite (mem_phi i) in h.
      assert (m := q _ h). toProp; intros [t1 t2]; elim m; split.
      rewrite <- (inv i r). apply (pres_le i); auto.
      intros t; elim t2.
      rewrite <- (inv' i w). apply (pres_le' i); auto.
   Qed.

   Lemma min_phi' : forall {A} {B} (i : ProIso A B) r c, mem (phi i r) (min B c) = mem r (min A (map (phi' i) c)).
   Proof. intros A B i r c.
      rewrite bool_eq; split; intros h.
      rewrite min_mem in h. destruct h as [p q].
      rewrite min_mem. split.
      rewrite <- (mem_phi' i); auto.
      intros w h. rewrite <- (mem_phi' i) in h.
      assert (m := q _ h). toProp; intros [t1 t2]; elim m; split.
      apply (pres_le i); auto.
      intros t; elim t2.
      rewrite <- (inv' i r), <- (inv' i w); apply (pres_le' i); auto.
      rewrite min_mem in h; destruct h as [p q];
      rewrite min_mem; split.
      rewrite (mem_phi' i); auto.
      intros w h.
      rewrite <- (mem_pres_eq c (inv i w)) in h.
      rewrite (mem_phi' i) in h.
      assert (m := q _ h). toProp; intros [t1 t2]; elim m; split.
      rewrite <- (inv' i r). apply (pres_le' i); auto.
      intros t; elim t2.
      rewrite <- (inv i w). apply (pres_le i); auto.
   Qed.

   Lemma isoPres : forall x y, ProIso x y -> DsIso (msetDecSetoid x) (msetDecSetoid y).
   Proof. intros x y i.
      apply (@Build_DsIso (msetDecSetoid x) (msetDecSetoid y)
         (map (phi i))
         (map (phi' i))).
      split.
      intros a b e.
         dseq_u; simpl in *; unfold eq_mset in *; simpl in *;
         rewrite eq_fset_mem in *. intros w.
         assert (h := e (phi' i w)).
         rewrite <- (min_phi i), <- (min_phi i); auto.
      intros a b e.
         dseq_u; simpl in *; unfold eq_mset in *; simpl in *;
         rewrite eq_fset_mem in *. intros w.
         assert (h := e (phi i w)).
         rewrite <- (min_phi' i), <- (min_phi' i); auto.
      intros a.
         dseq_u; simpl in *; unfold eq_mset in *; simpl in *.
         rewrite eq_fset_mem in *. intros w.
         rewrite <- (min_phi i), <- (min_phi' i); 
         rewrite (mem_pres_eq _ (inv i w)); auto.
      intros a.
         dseq_u; simpl in *; unfold eq_mset in *; simpl in *.
         rewrite eq_fset_mem in *. intros w.
         rewrite <- (min_phi' i), <- (min_phi i); 
         rewrite (mem_pres_eq _ (inv' i w)); auto.
   Defined.

   Lemma idPres : forall x y, IdProIso x y -> IdDsIso (msetDecSetoid x) (msetDecSetoid y).
   Proof. intros x y i; split with (isoPres x y i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *; apply IsId_map; auto.
   Defined.

End IsoPres.