Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Constructions.Semigroups.Postfix.
Require Import Metarouting.Constructions.Semigroups.Seq.
Require Import Metarouting.Constructions.Bisemigroups.PostfixSeq.
Require Import Metarouting.IsoPres.Semigroups.Postfix.
Require Import Metarouting.IsoPres.Semigroups.Seq.
Require Import Metarouting.IsoPres.DecSetoids.Seq.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.

Section IsoPres.

   Lemma isoPres : forall (x x' : DecSetoid), DsIso x x' ->
      BSmgIso (postfixSeqBisemigroup x) (postfixSeqBisemigroup x').
   Proof. intros x x' i. split with (DecSetoids.Seq.isoPres x x' i).
      split; simpl.
      
      apply (pres_op (Semigroups.Postfix.isoPres _ _ i)).
      apply (pres_op' (Semigroups.Postfix.isoPres _ _ i)).
      apply (pres_op (Semigroups.Seq.isoPres _ _ i)).
      apply (pres_op' (Semigroups.Seq.isoPres _ _ i)).
   Defined.

   Lemma idPres : forall (x x' : DecSetoid), IdDsIso x x' ->
      IdBSmgIso (postfixSeqBisemigroup x) (postfixSeqBisemigroup x').
   Proof. intros x x' i; split with (isoPres x x' i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *;
      simpl in *; auto.

      clear -ip1; destruct ip1; split; intros l; induction l; auto; simpl;
      rewrite IHl, (H a); auto.

      clear -ip1'; destruct ip1'; split; intros l; induction l; auto; simpl;
      rewrite IHl, (H a); auto.
   Defined.

End IsoPres.

