Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Constructions.DecSetoids.MultiSets.
Require Import Metarouting.Constructions.Semigroups.MultiSetsIntersection.
Require Import Metarouting.Constructions.Semigroups.MultiSetsUnion.
Require Import Metarouting.Constructions.Bisemigroups.MultiSets.
Require Import Metarouting.IsoPres.DecSetoids.MultiSets.
Require Import Metarouting.IsoPres.Semigroups.MultiSetsUnion.
Require Import Metarouting.IsoPres.Semigroups.MultiSetsIntersection.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Ltac toCount :=
      repeat rewrite multieq_count in *;
      repeat rewrite app_count in *;
      repeat rewrite multi_intersection_count in *.

   Ltac toCount_u :=
      dseq_u; simpl; toCount.

   Lemma isoPres : forall x x', DsIso x x' -> BSmgIso (multisetBisemigroup x) (multisetBisemigroup x').
   Proof. intros x x' i.
      split with (MultiSets.isoPres _ _ i).
      split.
      apply (pres_op (MultiSetsIntersection.isoPres _ _ i)).
      apply (pres_op' (MultiSetsIntersection.isoPres _ _ i)).
      apply (pres_op (MultiSetsUnion.isoPres _ _ i)).
      apply (pres_op' (MultiSetsUnion.isoPres _ _ i)).
   Defined.

   Lemma idPres : forall x x', IdDsIso x x' -> IdBSmgIso (multisetBisemigroup x) (multisetBisemigroup x').
   Proof. intros x x' i; split with (isoPres x x' i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *; apply IsId_map; auto.
   Defined.

End IsoPres.

