Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' y y' : Semigroup) e e', SmgIso x x' -> SmgIso y y' ->
      DsIso (glueBSmg x y e) (glueBSmg x' y' e').
   Proof. intros x x' y y' e e' i i'.
      destruct x; destruct y; simpl in *; destruct e.
      destruct x'; destruct y'; simpl in *; destruct e'.
      simpl in *. apply i.
      (*
      destruct x; destruct x'; destruct setoid; destruct setoid0; simpl in *;
      destruct y; destruct y'; destruct setoid; destruct setoid0; simpl in *.
      unfold glueBSmg; simpl.
      unfold DsEq in *. simpl in *.
      destruct e; destruct e'.
      apply i.*)
   Defined.
   
   Definition GlueBSmgIsoEq (x x' y y' : Semigroup) (e : DsEq x y) (e' : DsEq x' y') (i : DsIso x x') : Type.
      intros.
      set (Y := y); set (Y' := y').
      destruct x; destruct y; 
      destruct x'; destruct y'; simpl in *; destruct e; destruct e'.
      apply (IsSmgIso Y Y' i).
(*      destruct x; destruct x'; destruct setoid; destruct setoid0; simpl in *;
      destruct y; destruct y'; destruct setoid; destruct setoid0; simpl in *.
      unfold DsEq in *; simpl in *.
      destruct e; destruct e'.
      apply (IsSmgIso Y Y' i).*)
   Defined.
   
   Record GlueBSmgIso (x x' y y' : Semigroup) (e : DsEq x y) (e' : DsEq x' y') : Type := {
      gbsSmgIso1 : SmgIso x x';
      gbsSmgIso2 : GlueBSmgIsoEq x x' y y' e e' gbsSmgIso1 (* a compatible isomorphism*)
   }. 

   Lemma isoPres : forall x x' y y' e e', GlueBSmgIso x x' y y' e e' ->
      BSmgIso (glueBSmg x y e) (glueBSmg x' y' e').
   Proof. intros x x' y y' e e' gbs.
      destruct x; destruct x'; destruct y; destruct y'; simpl in *;
      destruct e; destruct e'.
      (* destruct x; destruct x'; destruct setoid; destruct setoid0; simpl in *;
      destruct y; destruct y'; destruct setoid; destruct setoid0; simpl in *.
      unfold glueBSmg; simpl.
      unfold DsEq in *. simpl in *. 
      destruct e; destruct e'. *)
      
      destruct gbs as [i1 i2].
      
      split with (Semigroup.dsIso i1); split; simpl in *.
      apply (pres_op  i1).
      apply (pres_op' i1).
      apply (pres_op  i2).
      apply (pres_op' i2).
   Defined. 

End IsoPres.
