Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.Semigroups.FSetsIntersect.
Require Import Metarouting.Constructions.Semigroups.FSetsUnion.
Require Import Metarouting.Constructions.Bisemigroups.FSets.
Require Import Metarouting.IsoPres.Semigroups.FSetsIntersect.
Require Import Metarouting.IsoPres.Semigroups.FSetsUnion.
Require Import Metarouting.IsoPres.DecSetoids.FSets.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' : DecSetoid), DsIso x x' ->
      DsIso (fsetBisemigroup x) (fsetBisemigroup x').
   Proof. intros x x' i.
      apply (IsoPres.DecSetoids.FSets.isoPres x x' i).
   Defined.

   Lemma isoPres : forall (x x' : DecSetoid), DsIso x x' ->
      BSmgIso (fsetBisemigroup x) (fsetBisemigroup x').
   Proof. intros x x' i. set (I := i).
      set (X := x); set (X' := x').
      split with (isoPres_helper x x' i).
      destruct x; destruct x'; simpl in *; destruct i; split; simpl in *.
      
      intros x y; toSet_u; rewrite <- (mem_phi I); toSet_u; repeat rewrite (mem_phi I); auto.

      intros x y; toSet_u; rewrite <- (mem_phi' I); toSet_u; repeat rewrite (mem_phi' I); auto.

      intros x y; toSet_u; rewrite <- (mem_phi I); toSet_u; repeat rewrite (mem_phi I); auto.

      intros x y; toSet_u; rewrite <- (mem_phi' I); toSet_u; repeat rewrite (mem_phi' I); auto.
   Defined.

   Lemma idPres : forall (x x' : DecSetoid), IdDsIso x x' ->
      IdBSmgIso (fsetBisemigroup x) (fsetBisemigroup x').
   Proof. intros x x' i.
      split with (isoPres x x' i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *;
      apply IsId_map; auto.
   Defined.

End IsoPres.

