Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.DecSetoids.FMinSets.
Require Import Metarouting.Constructions.Semigroups.FSetOp.
Require Import Metarouting.Constructions.Semigroups.FMinSetsUnion.
Require Import Metarouting.Constructions.Semigroups.FMinSetsOp.
Require Import Metarouting.Constructions.Bisemigroups.FMinSets.
Require Import Metarouting.IsoPres.DecSetoids.FMinSets.
Require Import Metarouting.IsoPres.Semigroups.FSetOp.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' : OrderSemigroup) lmon lmon' rmon rmon' antisym antisym', OSmgIso x x' ->
      DsIso (minsetBisemigroup x lmon rmon antisym) (minsetBisemigroup x' lmon' rmon' antisym').
   Proof. intros x x' lmon lmon' rmon rmon' antisym antisym' i.
      apply (IsoPres.DecSetoids.FMinSets.isoPres x x' i).
   Defined.

   Lemma isoPres : forall (x x' : OrderSemigroup) lmon lmon' rmon rmon' antisym antisym', OSmgIso x x' ->
      BSmgIso (minsetBisemigroup x lmon rmon antisym) (minsetBisemigroup x' lmon' rmon' antisym').
   Proof. intros x x' lmon lmon' rmon rmon' antisym antisym' i. set (I := i).
      set (X := x); set (X' := x');
      set (P := preorderOS x);
      set (P' := preorderOS x');
      split with (isoPres_helper x x' lmon lmon' rmon rmon' antisym antisym' i).
      destruct x; destruct x'; 
      destruct setoid; destruct setoid0; simpl in *; destruct i; split; simpl in *.
      
      intros x y. unfold mset_union. simpl.
      toSet_u. unfold eq_mset; dseq_f. apply min_pres_eq. toSet_u.
      rewrite <- (mem_phi I). rewrite min_phi. simpl. unfold preorderOS in *; simpl in *.
      generalize a; apply (min_pres_eq_mem P'). intros w.
      rewrite <- (mem_phi I). do 2 rewrite union_mem. do 2 rewrite (mem_phi I). auto.
      
      intros x y. unfold mset_union. simpl.
      toSet_u. unfold eq_mset; dseq_f. apply min_pres_eq. toSet_u.
      rewrite <- (mem_phi' I). rewrite min_phi'. simpl. unfold preorderOS in *; simpl in *.
      generalize a; apply (min_pres_eq_mem P). intros w.
      rewrite <- (mem_phi' I). do 2 rewrite union_mem. do 2 rewrite (mem_phi' I). auto.
      
      intros x y. unfold mset_op. simpl.
      toSet_u. unfold eq_mset; dseq_f. apply min_pres_eq. toSet_u.
      rewrite <- (mem_phi I). rewrite min_phi. simpl. unfold preorderOS in *; simpl in *.
      generalize a; apply (min_pres_eq_mem P'). intros w.
      assert (p := phi_fset_op _ _ I x y). dseq_u; simpl in p; rewrite eq_fset_mem in p. apply p.

      intros x y. unfold mset_op. simpl.
      toSet_u. unfold eq_mset; dseq_f. apply min_pres_eq. toSet_u.
      rewrite <- (mem_phi' I). rewrite min_phi'. simpl. unfold preorderOS in *; simpl in *.
      generalize a; apply (min_pres_eq_mem P). intros w.
      assert (p := phi_fset_op' _ _ I x y). dseq_u; simpl in p; rewrite eq_fset_mem in p. apply p.
   Defined.

   Lemma idPres : forall (x x' : OrderSemigroup) lmon lmon' rmon rmon' antisym antisym', IdOSmgIso x x' ->
      IdBSmgIso (minsetBisemigroup x lmon rmon antisym) (minsetBisemigroup x' lmon' rmon' antisym').
   Proof. intros x x' lmon lmon' rmon rmon' antisym antisym' i.
      split with (isoPres x x' lmon lmon' rmon rmon' antisym antisym' i); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; destruct setoid; destruct setoid0; simpl in *;
      apply IsId_map; auto.
   Defined.

End IsoPres.

