Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformPropRecord.
Require Import Metarouting.Constructions.DecSetoids.Union.
Require Import Metarouting.Constructions.Transforms.Union.
Require Import Metarouting.Inference.DecSetoids.Union.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Signatures.IdArrow.

Definition unionTransform_DsEq_props 
              (D F G : DecSetoid)
              (AF : F -> D -> D) 
              (AG : G -> D -> D)
              (AEF : AppPreserve AF)
              (AEG : AppPreserve AG)
              (ap : tfProp (Build_Transform AEF))
              (bp : tfProp (Build_Transform AEG))
              : tfProp (unionTransform_DsEq D F G AF AG AEF AEG).
   intros.
   apply (Build_tfProp (unionTransform_DsEq D F G AF AG AEF AEG)
      ap (unionDecSetoid_props (tf_fndsprop _ ap) (tf_fndsprop _ bp)));
   hypPropSplit.
   
   (* Cancelative *)
   apply (opMap (Union.cancelative D F G AF AG AEF AEG)); opUnfoldBoolFormula; fail.
   apply (opMap (Union.cancelative_comp D F G AF AG AEF AEG)); opUnfoldBoolFormula; fail.
   
   (* Condensed *)
   apply (opMap (Union.condensed D F G AF AG AEF AEG)); opUnfoldBoolFormula; fail.
   apply (opMap (Union.condensed_comp D F G AF AG AEF AEG)); opUnfoldBoolFormula; fail.
Defined.

Definition unionTransform_props {a} {b} (ap : tfProp a) (pb : tfProp b) (iso : DsIso a b) : tfProp (unionTransform a b iso).
   intros a b ap bp iso; unfold unionTransform.
   
   destruct a; destruct setoid;
   destruct b; destruct setoid; simpl in *.
   
   apply unionTransform_DsEq_props.
   
   apply (@tfPropIso (Build_Transform app_pres_eq)); auto;
   split with (DsIso_refl (Build_DecSetoid choose equal refl sym trans)) (DsIso_refl fn);
   split; simpl; intros; auto.
   
   apply (@tfPropIso (Build_Transform app_pres_eq0)); auto.
   split with (DsIso_sym iso) (DsIso_refl fn0).
   split; simpl; intros.
   apply (pres_eq' iso); apply app_pres_eq0; auto; rewrite (inv iso x); auto.
   rewrite (inv iso); auto.
Defined.