Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.TopUnion.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Unit.
Require Import Metarouting.Inference.DecSetoids.Union.

Definition topUnionSemigroup_props {a} {b} (ap : sgProp a) (bp : sgProp b) : sgProp (topUnionSemigroup a b).
   intros a b ap bp;
   apply (Build_sgProp (topUnionSemigroup a b) (unionDecSetoid_props (unionDecSetoid_props ap bp) (unitDecSetoid_props)));
   hypPropSplit.
   
   (* HasIdentity *)
   apply None.
   apply (opInit (@TopUnion.hasIdentity_comp a b)).

   (* HasAnnihilator *)
   apply (opInit (@TopUnion.hasAnnihilator a b)).
   apply None.

   (* IsSelective *)
   apply None.
   apply (opInit (@TopUnion.isSelective_comp a b)); opUnfoldBoolFormula; fail.

   (* IsCommutative *)
   apply (opMap (@TopUnion.isCommutative a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@TopUnion.isCommutative_comp a b)); opUnfoldBoolFormula; fail.

   (* IsIdempotent *)
   apply (opMap (@TopUnion.isIdempotent a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@TopUnion.isIdempotent_comp a b)); opUnfoldBoolFormula; fail.

   (* IsLeft *)
   apply None.
   apply (opInit (@TopUnion.isLeft_comp a b)).

   (* IsRight *)
   apply None.
   apply (opInit (@TopUnion.isRight_comp a b)).

   (* LeftCondensed *)
   apply None.
   apply (opInit (@TopUnion.leftCondensed_comp a b)).

   (* RightCondensed *)
   apply None.
   apply (opInit (@TopUnion.rightCondensed_comp a b)).

   (* LeftCancelative *)
   apply None.
   apply (opInit (@TopUnion.leftCancelative_comp a b)).

   (* RightCancelative *)
   apply None.
   apply (opInit (@TopUnion.rightCancelative_comp a b)).

   (* AntiLeft *)
   apply None.
   apply (opInit (@TopUnion.antiLeft_comp a b)).

   (* AntiRight *)
   apply None.
   apply (opInit (@TopUnion.antiRight_comp a b)).

   (* TreeGlb *)
   apply (opMap (@TopUnion.treeGlb a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@TopUnion.treeGlb_comp a b)); opUnfoldBoolFormula; fail.
Defined.
