Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.SimpleSeq.
Require Import Metarouting.Constructions.Semigroups.SimpleSeq.

Definition simpleSeqSemigroup_props {a} (ap : dsProp a) : sgProp (simpleSeqSemigroup a).
   intros a ap.
   apply (Build_sgProp (simpleSeqSemigroup a) (simpleSeqDecSetoid_props ap));
   hypPropSplit.
   
   (* HasIdentity *)
   apply (opInit (SimpleSeq.hasIdentity a)).
   apply None.

   (* HasAnnihilator *)
   apply (opInit (SimpleSeq.hasAnnihilator a)).
   apply None.

   (* IsSelective *)
   apply None.
   apply (opInit (SimpleSeq.isSelective_comp a)).

   (* IsCommutative *)
   apply (opMap (@SimpleSeq.isCommutative a)); opUnfoldBoolFormula; fail.
   apply (opMap (@SimpleSeq.isCommutative_comp a)); opUnfoldBoolFormula; fail.

   (* IsIdempotent *)
   apply None.
   apply (opInit (SimpleSeq.isIdempotent_comp a)).

   (* IsLeft *)
   apply None.
   apply (opInit (SimpleSeq.isLeft_comp a)).

   (* IsRight *)
   apply None.
   apply (opInit (SimpleSeq.isRight_comp a)).

   (* LeftCondensed *)
   apply None.
   apply (opInit (SimpleSeq.leftCondensed_comp a)).

   (* RightCondensed *)
   apply None.
   apply (opInit (SimpleSeq.rightCondensed_comp a)).

   (* LeftCancelative *)
   apply None.
   apply (opInit (SimpleSeq.leftCancelative_comp a)).

   (* RightCancelative *)
   apply None.
   apply (opInit (SimpleSeq.rightCancelative_comp a)).

   (* AntiLeft *)
   apply None.
   apply (opInit (@SimpleSeq.antiLeft_comp a)).

   (* AntiRight *)
   apply None.
   apply (opInit (@SimpleSeq.antiRight_comp a)).

   (* TreeGlb *)
   apply (opInit (@SimpleSeq.treeGlb a)).
   apply None.
Defined.
