Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Seq.
Require Import Metarouting.Constructions.Semigroups.Seq.

Definition seqSemigroup_props {a} (ap : dsProp a) : sgProp (seqSemigroup a).
   intros a ap.
   apply (Build_sgProp (seqSemigroup a) (seqDecSetoid_props ap));
   hypPropSplit.
   
   (* HasIdentity *)
   apply (opInit (Seq.hasIdentity a)).
   apply None.

   (* HasAnnihilator *)
   apply None.
   apply (opInit (Seq.hasAnnihilator_comp a)).

   (* IsSelective *)
   apply None.
   apply (opInit (Seq.isSelective_comp a)).

   (* IsCommutative *)
   apply (opMap (@Seq.isCommutative a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Seq.isCommutative_comp a)); opUnfoldBoolFormula; fail.

   (* IsIdempotent *)
   apply None.
   apply (opInit (Seq.isIdempotent_comp a)).

   (* IsLeft *)
   apply None.
   apply (opInit (Seq.isLeft_comp a)).

   (* IsRight *)
   apply None.
   apply (opInit (Seq.isRight_comp a)).

   (* LeftCondensed *)
   apply None.
   apply (opInit (Seq.leftCondensed_comp a)).

   (* RightCondensed *)
   apply None.
   apply (opInit (Seq.rightCondensed_comp a)).

   (* LeftCancelative *)
   apply (opInit (Seq.leftCancelative a)).
   apply None.

   (* RightCancelative *)
   apply (opInit (Seq.rightCancelative a)).
   apply None.

   (* AntiLeft *)
   apply None.
   apply (opInit (@Seq.antiLeft_comp a)).

   (* AntiRight *)
   apply None.
   apply (opInit (@Seq.antiRight_comp a)).

   (* TreeGlb *)
   apply (opInit (@Seq.treeGlb a)).
   apply None.
Defined.
