Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.SelLex.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Product.

Definition selLexSemigroup_props {a} {b} comm sel (ap : sgProp a) (bp : sgProp b) : sgProp (selLexSemigroup a b comm sel).
   intros;
   apply (Build_sgProp (selLexSemigroup a b comm sel) (prodDecSetoid_props ap bp));
   hypPropSplit.
   
   (* HasIdentity *)
   apply (opMap (@SelLex.hasIdentity a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.hasIdentity_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* HasAnnihilator *)
   apply (opMap (@SelLex.hasAnnihilator a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.hasAnnihilator_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* IsSelective *)
   apply (opMap (@SelLex.isSelective a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.isSelective_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* IsCommutative *)
   apply (opMap (@SelLex.isCommutative a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.isCommutative_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* IsIdempotent *)
   apply (opMap (@SelLex.isIdempotent a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.isIdempotent_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* IsLeft *)
   apply (opMap (@SelLex.isLeft a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.isLeft_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* IsRight *)
   apply (opMap (@SelLex.isRight a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.isRight_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* LeftCondensed *)
   apply (opMap (@SelLex.leftCondensed a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.leftCondensed_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* RightCondensed *)
   apply (opMap (@SelLex.rightCondensed a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.rightCondensed_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* LeftCancelative *)
   apply (opMap (@SelLex.leftCancelative a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.leftCancelative_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* RightCancelative *)
   apply (opMap (@SelLex.rightCancelative a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.rightCancelative_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* AntiLeft *)
   apply (opMap (@SelLex.antiLeft a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.antiLeft_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* AntiRight *)
   apply (opMap (@SelLex.antiRight a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.antiRight_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* TreeGlb *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)
Defined.
