Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.Right.
Require Import Metarouting.Inference.Common.Common.

Definition rightSemigroup_props {a} (ap : dsProp a) : sgProp (rightSemigroup a).
   intros a ap;
   apply (Build_sgProp (rightSemigroup a) ap);
   hypPropSplit.
   
   (* HasIdentity *)
   apply (opMap (@Right.hasIdentity a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Right.hasIdentity_comp a)); opUnfoldBoolFormula; fail.

   (* HasAnnihilator *)
   apply (opMap (@Right.hasAnnihilator a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Right.hasAnnihilator_comp a)); opUnfoldBoolFormula; fail.

   (* IsSelective *)
   apply (opInit (@Right.isSelective a)).
   apply None.

   (* IsCommutative *)
   apply (opMap (@Right.isCommutative a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Right.isCommutative_comp a)); opUnfoldBoolFormula; fail.

   (* IsIdempotent *)
   apply (opInit (@Right.isIdempotent a)).
   apply None.

  (* IsLeft *)
   apply (opMap (@Right.isLeft a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Right.isLeft_comp a)); opUnfoldBoolFormula; fail.

   (* IsRight *)
   apply (opInit (@Right.isRight a)).
   apply None.

   (* LeftCondensed *)
   apply (opMap (@Right.leftCondensed a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Right.leftCondensed_comp a)); opUnfoldBoolFormula; fail.

   (* RightCondensed *)
   apply (opInit (@Right.rightCondensed a)).
   apply None.

   (* LeftCancelative *)
   apply (opInit (@Right.leftCancelative a)).
   apply None.
     
   (* RightCancelative *)
   apply (opMap (@Right.rightCancelative a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Right.rightCancelative_comp a)); opUnfoldBoolFormula; fail.


   (* AntiLeft *)
   apply None.
   apply (opInit (@Right.antiLeft_comp a)).

   (* AntiRight *)
   apply None.
   apply (opInit (@Right.antiRight_comp a)).

   (* TreeGlb *)
   apply (opInit (@Right.treeGlb a)).
   apply None.
Defined.
