Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.NatMax.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Nat.

Definition natMaxSemigroup_props : sgProp natMaxSemigroup.
   apply Build_sgProp.
   apply natDecSetoid_props.
   
   (* HasIdentity *)
   apply (opInit NatMax.hasIdentity).
   apply None.

   (* HasAnnihilator *)
   apply None.
   apply (opInit NatMax.hasAnnihilator_comp).

   (* IsSelective *)
   apply (opInit NatMax.isSelective).
   apply None.

   (* IsCommutative *)
   apply (opInit NatMax.isCommutative).
   apply None.

   (* IsIdempotent *)
   apply (opInit NatMax.isIdempotent).
   apply None.

   (* IsLeft *)
   apply None.
   apply (opInit NatMax.isLeft_comp).

   (* IsRight *)
   apply None.
   apply (opInit NatMax.isRight_comp).

   (* LeftCondensed *)
   apply None.
   apply (opInit NatMax.leftCondensed_comp).

   (* RightCondensed *)
   apply None.
   apply (opInit NatMax.rightCondensed_comp).

   (* LeftCancelative *)
   apply None.
   apply (opInit NatMax.leftCancelative_comp).

   (* RightCancelative *)
   apply None.
   apply (opInit NatMax.rightCancelative_comp).

   (* AntiLeft *)
   apply None.
   apply (opInit NatMax.antiLeft_comp).

   (* AntiRight *)
   apply None.
   apply (opInit NatMax.antiRight_comp).

   (* TreeGlb *)
   apply (opInit NatMax.treeGlb).
   apply None.
Defined.
