Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.MultiSetsUnion.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.MultiSets.

Definition multisetUnionSemigroup_props {a} (ap : dsProp a) : sgProp (multisetUnionSemigroup a).
   intros;
   apply (Build_sgProp (multisetUnionSemigroup a) (multisetDecSetoid_props ap));
   hypPropSplit.
   
   (* HasIdentity *)
   apply (opInit (@MultiSetsUnion.hasIdentity a)).
   apply None.

   (* HasAnnihilator *)
   apply None.
   apply (opInit (@MultiSetsUnion.hasAnnihilator_comp a)).

   (* IsSelective *)
   apply None.
   apply (opInit (@MultiSetsUnion.isSelective_comp a)).

   (* IsCommutative *)
   apply (opInit (@MultiSetsUnion.isCommutative a)).
   apply None.

   (* IsIdempotent *)
   apply None.
   apply (opInit (@MultiSetsUnion.isIdempotent_comp a)).

   (* IsLeft *)
   apply None.
   apply (opInit (@MultiSetsUnion.isLeft_comp a)).

   (* IsRight *)
   apply None.
   apply (opInit (@MultiSetsUnion.isRight_comp a)).

   (* LeftCondensed *)
   apply None.
   apply (opInit (@MultiSetsUnion.leftCondensed_comp a)).

   (* RightCondensed *)
   apply None.
   apply (opInit (@MultiSetsUnion.rightCondensed_comp a)).

   (* LeftCancelative *)
   apply (opInit (@MultiSetsUnion.leftCancelative a)).
   apply None.

   (* RightCancelative *)
   apply (opInit (@MultiSetsUnion.rightCancelative a)).
   apply None.

   (* AntiLeft *)
   apply None.
   apply (opInit (@MultiSetsUnion.antiLeft_comp a)).

   (* AntiRight *)
   apply None.
   apply (opInit (@MultiSetsUnion.antiRight_comp a)).

   (* TreeGlb *)
   apply (opInit (@MultiSetsUnion.treeGlb a)).
   apply None.
Defined.
