Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.MultiSetsIntersection.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.MultiSets.

Definition multisetIntersectionSemigroup_props {a} (ap : dsProp a) : sgProp (multisetIntersectionSemigroup a).
   intros;
   apply (Build_sgProp (multisetIntersectionSemigroup a) (multisetDecSetoid_props ap));
   hypPropSplit.
   
   (* HasIdentity *)
   apply None.
   apply (opInit (@MultiSetsIntersection.hasIdentity_comp a)).

   (* HasAnnihilator *)
   apply (opInit (@MultiSetsIntersection.hasAnnihilator a)).
   apply None.

   (* IsSelective *)
   apply (opMap (@MultiSetsIntersection.isSelective a)); opUnfoldBoolFormula; fail.
   apply (opMap (@MultiSetsIntersection.isSelective_comp a)); opUnfoldBoolFormula; fail.

   (* IsCommutative *)
   apply (opInit (@MultiSetsIntersection.isCommutative a)).
   apply None.

   (* IsIdempotent *)
   apply (opInit (@MultiSetsIntersection.isIdempotent a)).
   apply None.

   (* IsLeft *)
   apply None.
   apply (opInit (@MultiSetsIntersection.isLeft_comp a)).

   (* IsRight *)
   apply None.
   apply (opInit (@MultiSetsIntersection.isRight_comp a)).

   (* LeftCondensed *)
   apply None.
   apply (opInit (@MultiSetsIntersection.leftCondensed_comp a)).

   (* RightCondensed *)
   apply None.
   apply (opInit (@MultiSetsIntersection.rightCondensed_comp a)).

   (* LeftCancelative *)
   apply None.
   apply (opInit (@MultiSetsIntersection.leftCancelative_comp a)).

   (* RightCancelative *)
   apply None.
   apply (opInit (@MultiSetsIntersection.rightCancelative_comp a)).

   (* AntiLeft *)
   apply None.
   apply (opInit (@MultiSetsIntersection.antiLeft_comp a)).

   (* AntiRight *)
   apply None.
   apply (opInit (@MultiSetsIntersection.antiRight_comp a)).

   (* TreeGlb *)
   apply (opMap (@MultiSetsIntersection.treeGlb a)); opUnfoldBoolFormula; fail.
   apply (opMap (@MultiSetsIntersection.treeGlb_comp a)); opUnfoldBoolFormula; fail.
Defined.
