Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.Lex.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Product.

Definition lexSemigroup_props {a} {b} comm idem hid (ap : sgProp a) (bp : sgProp b) : sgProp (lexSemigroup a b comm idem hid).
   intros;
   apply (Build_sgProp (lexSemigroup a b comm idem hid) (prodDecSetoid_props ap bp));
   hypPropSplit.
   
   (* HasIdentity *)
   apply (opMap (@Lex.hasIdentity a b comm idem hid)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.hasIdentity_comp a b comm idem hid)); opUnfoldBoolFormula; fail.

   (* HasAnnihilator *)
   apply (opMap (@Lex.hasAnnihilator a b comm idem hid)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.hasAnnihilator_comp a b comm idem hid)); opUnfoldBoolFormula; fail.

   (* IsSelective *)
   apply (opMap (@Lex.isSelective a b comm idem hid)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.isSelective_comp a b comm idem hid)); opUnfoldBoolFormula; fail.

   (* IsCommutative *)
   apply (opMap (@Lex.isCommutative a b comm idem hid)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.isCommutative_comp a b comm idem hid)); opUnfoldBoolFormula; fail.

   (* IsIdempotent *)
   apply (opMap (@Lex.isIdempotent a b comm idem hid)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.isIdempotent_comp a b comm idem hid)); opUnfoldBoolFormula; fail.

   (* IsLeft *)
   apply (opMap (@Lex.isLeft a b comm idem hid)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.isLeft_comp a b comm idem hid)); opUnfoldBoolFormula; fail.

   (* IsRight *)
   apply (opMap (@Lex.isRight a b comm idem hid)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.isRight_comp a b comm idem hid)); opUnfoldBoolFormula; fail.

   (* LeftCondensed *)
   apply (opMap (@Lex.leftCondensed a b comm idem hid)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.leftCondensed_comp a b comm idem hid)); opUnfoldBoolFormula; fail.

   (* RightCondensed *)
   apply (opMap (@Lex.rightCondensed a b comm idem hid)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.rightCondensed_comp a b comm idem hid)); opUnfoldBoolFormula; fail.

   (* LeftCancelative *)
   apply (opMap (@Lex.leftCancelative a b comm idem hid)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.leftCancelative_comp a b comm idem hid)); opUnfoldBoolFormula; fail.

   (* RightCancelative *)
   apply (opMap (@Lex.rightCancelative a b comm idem hid)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.rightCancelative_comp a b comm idem hid)); opUnfoldBoolFormula; fail.

   (* AntiLeft *)
   apply (opMap (@Lex.antiLeft a b comm idem hid)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.antiLeft_comp a b comm idem hid)); opUnfoldBoolFormula; fail.

   (* AntiRight *)
   apply (opMap (@Lex.antiRight a b comm idem hid)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.antiRight_comp a b comm idem hid)); opUnfoldBoolFormula; fail.

   (* TreeGlb *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)
Defined.
