Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.FSetsUnion.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.FSets.

Definition fsetsUnionSemigroup_props {a} (ap : dsProp a) : sgProp (fsetsUnionSemigroup a).
   intros;
   apply (Build_sgProp (fsetsUnionSemigroup a) (fsetDecSetoid_props ap));
   hypPropSplit.
   
   (* HasIdentity *)
   apply (opInit (@FSetsUnion.hasIdentity a)).
   apply None.

   (* HasAnnihilator *)
   apply (opMap (@FSetsUnion.hasAnnihilator a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetsUnion.hasAnnihilator_comp a)); opUnfoldBoolFormula; fail.

   (* IsSelective *)
   apply (opMap (@FSetsUnion.isSelective a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetsUnion.isSelective_comp a)); opUnfoldBoolFormula; fail.

   (* IsCommutative *)
   apply (opInit (@FSetsUnion.isCommutative a)).
   apply None.

   (* IsIdempotent *)
   apply (opInit (@FSetsUnion.isIdempotent a)).
   apply None.

   (* IsLeft *)
   apply None.
   apply (opInit (@FSetsUnion.isLeft_comp a)).

   (* IsRight *)
   apply None.
   apply (opInit (@FSetsUnion.isRight_comp a)).

   (* LeftCondensed *)
   apply None.
   apply (opInit (@FSetsUnion.leftCondensed_comp a)).

   (* RightCondensed *)
   apply None.
   apply (opInit (@FSetsUnion.rightCondensed_comp a)).

   (* LeftCancelative *)
   apply None.
   apply (opInit (@FSetsUnion.leftCancelative_comp a)).

   (* RightCancelative *)
   apply None.
   apply (opInit (@FSetsUnion.rightCancelative_comp a)).

   (* AntiLeft *)
   apply None.
   apply (opInit (@FSetsUnion.antiLeft_comp a)).

   (* AntiRight *)
   apply None.
   apply (opInit (@FSetsUnion.antiRight_comp a)).

   (* TreeGlb *)
   apply (opMap (@FSetsUnion.treeGlb a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetsUnion.treeGlb_comp a)); opUnfoldBoolFormula; fail.
Defined.
