Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.BoolOr.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Bool.

Definition boolOrSemigroup_props : sgProp boolOrSemigroup.
   apply Build_sgProp.
   apply boolDecSetoid_props.
   
   (* HasIdentity *)
   apply (opInit BoolOr.hasIdentity).
   apply None.

   (* HasAnnihilator *)
   apply (opInit BoolOr.hasAnnihilator).
   apply None.

   (* IsSelective *)
   apply (opInit BoolOr.isSelective).
   apply None.

   (* IsCommutative *)
   apply (opInit BoolOr.isCommutative).
   apply None.

   (* IsIdempotent *)
   apply (opInit BoolOr.isIdempotent).
   apply None.

   (* IsLeft *)
   apply None.
   apply (opInit BoolOr.isLeft_comp).

   (* IsRight *)
   apply None.
   apply (opInit BoolOr.isRight_comp).

   (* LeftCondensed *)
   apply None.
   apply (opInit BoolOr.leftCondensed_comp).

   (* RightCondensed *)
   apply None.
   apply (opInit BoolOr.rightCondensed_comp).

   (* LeftCancelative *)
   apply None.
   apply (opInit BoolOr.leftCancelative_comp).

   (* RightCancelative *)
   apply None.
   apply (opInit BoolOr.rightCancelative_comp).

   (* AntiLeft *)
   apply None.
   apply (opInit BoolOr.antiLeft_comp).

   (* AntiRight *)
   apply None.
   apply (opInit BoolOr.antiRight_comp).

   (* TreeGlb *)
   apply (opInit BoolOr.treeGlb).
   apply None.
Defined.
