Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformPropRecord.
Require Import Metarouting.Signatures.SemigroupTransformGlue.
Require Import Metarouting.Constructions.DecSetoids.Union.
Require Import Metarouting.Constructions.SemigroupTransforms.Union.
Require Import Metarouting.Inference.DecSetoids.Union.
Require Import Metarouting.Inference.Transforms.Union.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Signatures.IdArrow.

Definition unionSemigroupTransform_SgEq_props
              (S : Semigroup)
              (F G : DecSetoid)
              (AF : F -> S -> S)
              (AG : G -> S -> S)
              (AEF : AppPreserve AF)
              (AEG : AppPreserve AG)
              (ap : stProp ((Build_SemigroupTransform (Semigroup.assoc S) (Semigroup.op_pres_eq S) AEF))) 
              (pb : stProp ((Build_SemigroupTransform (Semigroup.assoc S) (Semigroup.op_pres_eq S) AEG))) 
              : stProp (unionSemigroupTransform_SgEq S F G AF AG AEF AEG).
   intros.
   assert (sgProp (unionSemigroupTransform_SgEq S F G AF AG AEF AEG)) as sgp.
      apply (sgPropIso (glueSTfSmg_DsEq S (Union.unionTransform_DsEq S F G AF AG AEF AEG) _)).
      destruct S; apply ap.
   assert (tfProp (unionSemigroupTransform_SgEq S F G AF AG AEF AEG)) as tfp.
     apply (tfPropIso (glueSTfTf_DsEq S (Union.unionTransform_DsEq S F G AF AG AEF AEG) _)).
     apply unionTransform_DsEq_props. apply ap. apply pb.

   apply (Build_stProp (unionSemigroupTransform_SgEq S F G AF AG AEF AEG) sgp tfp);
   hypPropSplit.
   

   (* Distributive *)
   apply (opMap (Union.distributive S F G AF AG AEF AEG)); opUnfoldBoolFormula; fail.
   apply (opMap (Union.distributive_comp S F G AF AG AEF AEG)); opUnfoldBoolFormula; fail.

   (* Inflationary *)
   apply (opMap (Union.inflationary S F G AF AG AEF AEG)); opUnfoldBoolFormula; fail.
   apply (opMap (Union.inflationary_comp S F G AF AG AEF AEG)); opUnfoldBoolFormula; fail.

   (* StrictInflationary *)
   apply (opMap (Union.strictInflationary S F G AF AG AEF AEG)); opUnfoldBoolFormula; fail.
   apply (opMap (Union.strictInflationary_comp S F G AF AG AEF AEG)); opUnfoldBoolFormula; fail.

   (* Strict *)
   apply (opMap (Union.strict S F G AF AG AEF AEG)); opUnfoldBoolFormula; fail.
   apply (opMap (Union.strict_comp S F G AF AG AEF AEG)); opUnfoldBoolFormula; fail.
Defined.

Definition unionSemigroupTransform_props {a} {b} (ap : stProp a) (pb : stProp b) (iso : IdSmgIso a b) : stProp (unionSemigroupTransform a b iso).
   intros a b ap bp iso.

   destruct a; destruct setoid;
   destruct b; destruct setoid; simpl in *.
   
   apply unionSemigroupTransform_SgEq_props.
   
   apply (@stPropIso (Build_SemigroupTransform assoc op_pres_eq app_pres_eq)); auto.
   split with (DsIso_refl (Build_DecSetoid choose equal refl sym trans)) (DsIso_refl fn);
   split; simpl; intros; auto.
   
   apply (@stPropIso (Build_SemigroupTransform assoc0 op_pres_eq0 app_pres_eq0)); auto.
   split with (DsIso_sym iso) (DsIso_refl fn0).
   split; simpl; intros.
   rewrite (Semigroup.pres_op' iso); auto.
   rewrite (Semigroup.pres_op iso); auto.
   apply (pres_eq' iso); apply app_pres_eq0; auto; rewrite (inv iso x); auto.
   rewrite (inv iso); auto.
Defined.