Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformPropRecord.
Require Import Metarouting.Signatures.SemigroupTransformGlue.
Require Import Metarouting.Constructions.Semigroups.SelLex.
Require Import Metarouting.Constructions.Transforms.Product.
Require Import Metarouting.Constructions.SemigroupTransforms.SelLex.
Require Import Metarouting.Inference.Transforms.Product.
Require Import Metarouting.Inference.Semigroups.SelLex.
Require Import Metarouting.Inference.Common.Common.

Definition selLexSemigroupTransform_props {a b} (ap : stProp a) (bp : stProp b) comm sel (B_comm : IsCommutative b) : stProp (selLexSemigroupTransform a b comm sel).
   intros.
   
   assert (sgProp (selLexSemigroupTransform a b comm sel)) as sgp.
      apply (sgPropIso (glueSTfSmg_DsEq (selLexSemigroup a b comm sel) (prodTransform a b) _)).
      apply selLexSemigroup_props. apply ap. apply bp.

   assert (tfProp (selLexSemigroupTransform a b comm sel)) as tfp.
      apply (tfPropIso (glueSTfTf_DsEq (selLexSemigroup a b comm sel) (prodTransform a b) _)).
      apply prodTransform_props. apply ap. apply bp.

   apply (Build_stProp (selLexSemigroupTransform a b comm sel) sgp tfp);
   hypPropSplit.

   (* Distributive *)
   apply (opMap (SelLex.distributive a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (SelLex.distributive_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* Inflationary *)
   apply (opMap (SelLex.inflationary a b comm sel B_comm)); opUnfoldBoolFormula; fail.
   apply (opMap (SelLex.inflationary_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* StrictInflationary *)
   apply (opMap (SelLex.strictInflationary a b comm sel B_comm)); opUnfoldBoolFormula; fail.
   apply (opMap (SelLex.strictInflationary_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* Strict *)
   apply (opMap (SelLex.strict a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (SelLex.strict_comp a b comm sel)); opUnfoldBoolFormula; fail.

Defined.

