Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformPropRecord.
Require Import Metarouting.Signatures.SemigroupTransformGlue.
Require Import Metarouting.Constructions.SemigroupTransforms.Right.
Require Import Metarouting.Inference.Transforms.Id.
Require Import Metarouting.Inference.Common.Common.

Definition rightSemigroupTransform_props {a} (ap : sgProp a) : stProp (rightSemigroupTransform a).
   intros a ap.
   
   assert (sgProp (rightSemigroupTransform a)) as sgp.
      apply (sgPropIso (glueSTfSmg_DsEq a (Id.idTransform a) _) ap).

   assert (tfProp (rightSemigroupTransform a)) as tfp.
      apply (tfPropIso (glueSTfTf_DsEq a (Id.idTransform a) _)).
      apply idTransform_props; apply ap.

   apply (Build_stProp (rightSemigroupTransform a) sgp tfp);
   hypPropSplit.

   (* Distributive *)
   apply (opInit (Right.distributive a)).
   apply None.

   (* Inflationary *)
   apply (opInit (Right.inflationary a)).
   apply None.

   (* StrictInflationary *)
   apply None.
   apply (opInit (Right.strictInflationary_comp a)).

   (* Strict *)
   apply (opInit (Right.strict a)).
   apply None.

Defined.
