Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformPropRecord.
Require Import Metarouting.Signatures.SemigroupTransformGlue.
Require Import Metarouting.Constructions.SemigroupTransforms.Left.
Require Import Metarouting.Inference.Transforms.Replace.
Require Import Metarouting.Inference.Common.Common.

Definition leftSemigroupTransform_props {a} (ap : sgProp a) : stProp (leftSemigroupTransform a).
   intros a ap.
   
   assert (sgProp (leftSemigroupTransform a)) as sgp.
      apply (sgPropIso (glueSTfSmg_DsEq a (Replace.replaceTransform a) _) ap).

   assert (tfProp (leftSemigroupTransform a)) as tfp.
      apply (tfPropIso (glueSTfTf_DsEq a (Replace.replaceTransform a) _));
      apply replaceTransform_props; apply ap.

   apply (Build_stProp (leftSemigroupTransform a) sgp tfp);
   hypPropSplit.

   (* Distributive *)
   apply (opMap (Left.distributive a)); opUnfoldBoolFormula; fail.
   apply (opMap (Left.distributive_comp a)); opUnfoldBoolFormula; fail.

   (* Inflationary *)
   apply (opMap (Left.inflationary a)); opUnfoldBoolFormula; fail.
   apply (opMap (Left.inflationary_comp a)); opUnfoldBoolFormula; fail.

   (* StrictInflationary *)
   apply None.
   apply (opInit (Left.strictInflationary_comp a)).

   (* Strict *)
   apply (opMap (Left.strict a)); opUnfoldBoolFormula; fail.
   apply (opMap (Left.strict_comp a)); opUnfoldBoolFormula; fail.

Defined.
