Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderPropRecord.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Preorders.LeftNaturalOrder.
Require Import Metarouting.Inference.Common.Common.

Definition leftNaturalOrder_props {a} (ap : sgProp a) idem (comm : IsCommutative a) : poProp (leftNaturalOrder a idem).
   intros; 
   apply (Build_poProp (leftNaturalOrder a idem) ap);
   hypPropSplit.
   
   (* HasTop *)
   apply (opMap (@LeftNaturalOrder.hasTop a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@LeftNaturalOrder.hasTop_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* HasBottom *)
   apply (opMap (@LeftNaturalOrder.hasBottom a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@LeftNaturalOrder.hasBottom_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* Total *)
   apply (opMap (@LeftNaturalOrder.total a idem comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@LeftNaturalOrder.total_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* Antisym *)
   apply (opMap (@LeftNaturalOrder.antisym a idem)); opUnfoldBoolFormula; fail.
   apply None.
Defined.
