Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderPropRecord.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Preorders.AnnTop.
Require Import Metarouting.Inference.Common.Common.

Definition annTopPreorder_props {a} (ap : sgProp a) (hasAnn : HasAnnihilator a) : poProp (annTopPreorder a hasAnn).
   intros; 
   apply (Build_poProp (annTopPreorder a hasAnn) ap);
   hypPropSplit.
   
   (* HasTop *)
   apply (opInit (@AnnTop.hasTop a hasAnn)).
   apply None.

   (* HasBottom *)
   apply (opMap (@AnnTop.hasBottom a hasAnn)); opUnfoldBoolFormula; fail.
   apply (opMap (@AnnTop.hasBottom_comp a hasAnn)); opUnfoldBoolFormula; fail.

   (* Total *)
   apply (opMap (@AnnTop.total a hasAnn)); opUnfoldBoolFormula; fail.
   apply (opMap (@AnnTop.total_comp a hasAnn)); opUnfoldBoolFormula; fail.

   (* Antisym *)
   apply (opInit (@AnnTop.antisym a hasAnn)).
   apply None.
Defined.
