Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.OrderSemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.SimpleSeq.
Require Import Metarouting.Inference.Semigroups.SimpleSeq.
Require Import Metarouting.Inference.Preorders.AnnTop.
Require Import Metarouting.Constructions.OrderSemigroups.SimpleSeq.

Definition simpleSeqOrderSemigroup_props {a} (ap : dsProp a) : osProp (simpleSeqOrderSemigroup a).
   intros.
   apply (Build_osProp (simpleSeqOrderSemigroup a) 
      (projSmgOSmgIso _ _ _ (simpleSeqSemigroup_props ap))
      (projProOSmgIso _ _ _ (annTopPreorder_props (simpleSeqSemigroup_props ap) (SimpleSeq.hasAnnihilator a))));
   hypPropSplit.
   
   (* LeftMonotonic *)
   apply (opInit (@SimpleSeq.leftMonotonic a)).
   apply None.

   (* RightMonotonic *)
   apply (opInit (@SimpleSeq.rightMonotonic a)).
   apply None.
   
   (* TopIsAnnihilator *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* TopIsIdentity *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* BottomIsAnnihilator *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* BottomIsIdentity *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* LeftOpNonDecreasing *)
   apply None.
   apply (opInit (@SimpleSeq.leftOpNonDecreasing_comp a)).

   (* RightOpNonDecreasing *)
   apply None.
   apply (opInit (@SimpleSeq.rightOpNonDecreasing_comp a)).

   (* SelectiveOpNonDecreasing *)
   apply (opInit (@SimpleSeq.selectiveOpNonDecreasing a)).
   apply None.

   (* LeftOpIncreasing *)
   apply None.
   apply (opInit (@SimpleSeq.leftOpIncreasing_comp a)).

   (* RightOpIncreasing *)
   apply None.
   apply (opInit (@SimpleSeq.rightOpIncreasing_comp a)).

   (* LeftCancelative *)
   apply None.
   apply (opInit (@SimpleSeq.leftEquivCancelative_comp a)).

   (* RightCancelative *)
   apply None.
   apply (opInit (@SimpleSeq.rightEquivCancelative_comp a)).

   (* LeftCondensed *)
   apply None.
   apply (opInit (@SimpleSeq.leftEquivCondensed_comp a)).

   (* RightCondensed *)
   apply None.
   apply (opInit (@SimpleSeq.rightEquivCondensed_comp a)).

   (* IncompArrowUniqueSrc *)
   apply (opInit (@SimpleSeq.incompArrowUniqueSrc a)).
   apply None.

   (* IncompArrowFactor *)
   apply (opInit (@SimpleSeq.incompArrowFactor a)).
   apply None.
Defined.
