Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.OrderSemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Product.
Require Import Metarouting.Inference.Preorders.LeftNaturalOrder.
Require Import Metarouting.Constructions.OrderSemigroups.BSLeftNaturalOrder.

Definition bsLeftNaturalOrder_props {a} (ap : bsProp a) idem 
                                    (comm : IsCommutative (plusSmg a)) 
                                    (ldist : IsLeftDistributive a) 
                                    (rdist : IsRightDistributive a) 
                                    : osProp (bsLeftNaturalOrder a idem).
   intros.
   apply (Build_osProp (bsLeftNaturalOrder a idem) 
      (projSmgOSmgIso _ _ _ (bs_times_sgprop _ ap))
      (projProOSmgIso _ _ _ (leftNaturalOrder_props (bs_plus_sgprop _ ap) idem comm)));
   hypPropSplit.
   
   (* LeftMonotonic *)
   apply (opInit (@BSLeftNaturalOrder.leftMonotonic a idem ldist)).
   apply None.

   (* RightMonotonic *)
   apply (opInit (@BSLeftNaturalOrder.rightMonotonic a idem rdist)).
   apply None.
   
   (* TopIsAnnihilator *)
   apply None.
   apply None.

   (* TopIsIdentity *)
   apply None.
   apply None.

   (* BottomIsAnnihilator *)
   apply None.
   apply None.

   (* BottomIsIdentity *)
   apply None.
   apply None.

   (* LeftOpNonDecreasing *)
   apply (opMap (@BSLeftNaturalOrder.leftOpNonDecreasing a idem comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@BSLeftNaturalOrder.leftOpNonDecreasing_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* RightOpNonDecreasing *)
   apply (opMap (@BSLeftNaturalOrder.rightOpNonDecreasing a idem comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@BSLeftNaturalOrder.rightOpNonDecreasing_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* SelectiveOpNonDecreasing *)
   apply None.
   apply None.

   (* LeftOpIncreasing *)
   apply (opMap (@BSLeftNaturalOrder.leftOpIncreasing a idem comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@BSLeftNaturalOrder.leftOpIncreasing_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* RightOpIncreasing *)
   apply (opMap (@BSLeftNaturalOrder.rightOpIncreasing a idem comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@BSLeftNaturalOrder.rightOpIncreasing_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* LeftCancelative *)
   apply (opMap (@BSLeftNaturalOrder.leftEquivCancelative a idem comm)); opUnfoldBoolFormula; fail.
   apply None. (* no iff *)

   (* RightCancelative *)
   apply (opMap (@BSLeftNaturalOrder.rightEquivCancelative a idem comm)); opUnfoldBoolFormula; fail.
   apply None. (* no iff *)

   (* LeftCondensed *)
   apply (opMap (@BSLeftNaturalOrder.leftEquivCondensed a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@BSLeftNaturalOrder.leftEquivCondensed_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* RightCondensed *)
   apply (opMap (@BSLeftNaturalOrder.rightEquivCondensed a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@BSLeftNaturalOrder.rightEquivCondensed_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* IncompArrowUniqueSrc *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* IncompArrowFactor *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)
Defined.
