Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.DecSetoidPropRecord.
Require Import Metarouting.Constructions.DecSetoids.Union.
Require Import Metarouting.Inference.Common.Common.

Definition unionDecSetoid_props {a} {b} (ap : dsProp a) (bp : dsProp b) : dsProp (unionDecSetoid a b).
   intros; hypPropSplit; apply Build_dsProp.
   
   (* IsSingleton *)
   apply None.
   apply (opInit (@Union.isSingleton_comp a b)).

   (* TwoElements *)
   apply (opMap (@Union.twoElements a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Union.twoElements_comp a b)); opUnfoldBoolFormula; fail.

   (* Finite *)
   apply (opMap (@Union.finite a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Union.finite_comp a b)); opUnfoldBoolFormula; fail.
Defined.
