Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.DecSetoidPropRecord.
Require Import Metarouting.Constructions.DecSetoids.Range.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Unit.
Require Import Metarouting.Inference.DecSetoids.Bool.

Definition rangeDecSetoid_props n : dsProp (rangeDecSetoid n).
   intros [|[|n]].
   
   (* n = 0 *) apply (dsPropIso (DsIso_sym Range.range0DsIso) unitDecSetoid_props).
   (* n = 1 *) apply (dsPropIso (DsIso_sym Range.range1DsIso) boolDecSetoid_props).
   (* n > 1 *) apply Build_dsProp.
   
   (* IsSingleton *)
   apply None.
   apply (opInit (@Range.isSingleton_comp n)).

   (* TwoElements *)
   apply None.
   apply (opInit (@Range.twoElements_comp n)).

   (* Finite *)
   apply (opInit (@Range.finite (S (S n)))).
   apply None.
Defined.
