Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoidPropRecord.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.PreorderPropRecord.
Require Import Metarouting.Signatures.TransformPropRecord.
Require Import Metarouting.Signatures.OrderSemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.SemigroupTransformPropRecord.

(********************************************************************)
(*            Common tactics for constructing semantics             *)
(********************************************************************)

   Ltac opUnfoldBoolFormula :=
	 trivial; fail
      || (apply opAnd; trivial; opUnfoldBoolFormula)
      || (apply opOr; trivial; opUnfoldBoolFormula)
      || idtac.

   Ltac ruleSearch2 rules :=
      (eapply opInit; rules; trivial; fail) (* try to apply axioms *)
   || (eapply opMap; [rules|]; trivial; opUnfoldBoolFormula; trivial; ruleSearch2 rules). (* try to apply rules *)

   Ltac hypPropSplit :=
      repeat
      match goal with
        | h : sgProp _ |- _ => destruct h
        | h : dsProp _ |- _ => destruct h
        | h : poProp _ |- _ => destruct h
        | h : osProp _ |- _ => destruct h
        | h : bsProp _ |- _ => destruct h
        | h : tfProp _ |- _ => destruct h
        | h : stProp _ |- _ => destruct h
      end.

