Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Semigroups.RangePlus.
Require Import Metarouting.Inference.Semigroups.RangeMin.
Require Import Metarouting.Inference.Bisemigroups.Unit.
Require Import Metarouting.Inference.Bisemigroups.BoolOrAnd.
Require Import Metarouting.Constructions.Bisemigroups.RangeMinPlus.

Definition rangeMinPlusBisemigroup_props n : bsProp (rangeMinPlusBisemigroup n).
   intros [|[|n]].
   apply (bsPropIso (BSmgIso_sym rminplus0BSmgIso) unitBisemigroup_props).
   apply (bsPropIso (BSmgIso_sym rminplus1BSmgIso) boolOrAndBisemigroup_props).

   apply (Build_bsProp (rangeMinPlusBisemigroup (S (S n)))
         (projPlusBSmgIso _ _ _  (rangeMinSemigroup_props (S (S n))))
         (projTimesBSmgIso _ _ _ (rangePlusSemigroup_props (S (S n))))).

   (* IsLeftDistributive *)
   apply (opInit (@RangeMinPlus.isLeftDistributive (2 + n))).
   apply None.

   (* IsRightDistributive *)
   apply (opInit (@RangeMinPlus.isRightDistributive (2 + n))).
   apply None.

(*
   (* IsLeftCoDistributive *)
   apply None.
   apply (opInit (@RangeMinPlus.isLeftCoDistributive_comp n)).

   (* IsRightCoDistributive *)
   apply None.
   apply (opInit (@RangeMinPlus.isRightCoDistributive_comp n)).
*)

   (* PlusIdentityIsTimesAnnihilator *)
   apply (opInit (@RangeMinPlus.plusIdentityIsTimesAnnihilator (1 + n))).
   apply None.

   (* PlusAnnihilatorIsTimesIdentity *)
   apply (opInit (@RangeMinPlus.plusAnnihilatorIsTimesIdentity (1 + n))).
   apply None.

   (* IsRightStrictStable *)
   apply None.
   apply (opInit (@RangeMinPlus.isRightStrictStable_comp (1 + n))).

   (* IsLeftStrictStable *)
   apply None.
   apply (opInit (@RangeMinPlus.isLeftStrictStable_comp (1 + n))).

   (* IsRightCompEqCancel *)
   apply (opInit (@RangeMinPlus.isRightCompEqCancel (2 + n))).
   apply None.

   (* IsLeftCompEqCancel *)
   apply (opInit (@RangeMinPlus.isLeftCompEqCancel (2 + n))).
   apply None.

   (* IsRightCompCancel *)
   apply (opInit (@RangeMinPlus.isRightCompCancel (2 + n))).
   apply None.

   (* IsLeftCompCancel *)
   apply (opInit (@RangeMinPlus.isLeftCompCancel (2 + n))).
   apply None.

   (* LeftDiscrete *)
   apply None.
   apply (opInit (@RangeMinPlus.leftDiscrete_comp (1 + n))).

   (* RightDiscrete *)
   apply None.
   apply (opInit (@RangeMinPlus.rightDiscrete_comp (1 + n))).

   (* LeftComparable *)
   apply (opInit (@RangeMinPlus.leftComparable (2 + n))).
   apply None.

   (* RightComparable *)
   apply (opInit (@RangeMinPlus.rightComparable (2 + n))).
   apply None.

   (* LeftIncreasing *)
   apply (opInit (@RangeMinPlus.leftIncreasing (1 + n))).
   apply None.

   (* RightIncreasing *)
   apply (opInit (@RangeMinPlus.rightIncreasing (1 + n))).
   apply None.

   (* LeftStrictIncreasing *)
   apply None.
   apply (opInit (@RangeMinPlus.leftStrictIncreasing_comp (2 + n))).

   (* RightStrictIncreasing *)
   apply None.
   apply (opInit (@RangeMinPlus.rightStrictIncreasing_comp (2 + n))).

   (* IsRightTimesMapToIdConstantPlus *)
   apply None.
   apply (opInit (@RangeMinPlus.isRightTimesMapToIdConstantPlus_comp (1 + n))).

   (* IsLeftTimesMapToIdConstantPlus *)
   apply None.
   apply (opInit (@RangeMinPlus.isLeftTimesMapToIdConstantPlus_comp (1 + n))).

   (* PlusIdentityIsTimesLeftAnnihilator *)
   apply (opInit (@RangeMinPlus.plusIdentityIsTimesLeftAnnihilator (2 + n))).
   apply None.

   (* PlusIdentityIsTimesRightAnnihilator *)
   apply (opInit (@RangeMinPlus.plusIdentityIsTimesRightAnnihilator (2 + n))).
   apply None.
Defined.
