Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Semigroups.RangeMax.
Require Import Metarouting.Inference.Semigroups.RangePlus.
Require Import Metarouting.Inference.Bisemigroups.Unit.
Require Import Metarouting.Constructions.Bisemigroups.RangeMaxPlus.

Definition rangeMaxPlusBisemigroup_props n : bsProp (rangeMaxPlusBisemigroup n).
   intros [|n].
   apply (bsPropIso (BSmgIso_sym rmaxplus0BSmgIso) unitBisemigroup_props).
   apply (Build_bsProp (rangeMaxPlusBisemigroup (S n))
         (projPlusBSmgIso _ _ _  (rangeMaxSemigroup_props (S n)))
         (projTimesBSmgIso _ _ _ (rangePlusSemigroup_props (S n)))).

   (* IsLeftDistributive *)
   apply (opInit (@RangeMaxPlus.isLeftDistributive (1 + n))).
   apply None.

   (* IsRightDistributive *)
   apply (opInit (@RangeMaxPlus.isRightDistributive (1 + n))).
   apply None.

(*
   (* IsLeftCoDistributive *)
   destruct n as [|n];
   [ apply (opInit (@RangeMaxPlus.isLeftCoDistributive1))
   | apply None].
   destruct n as [|n];
   [ apply None
   | apply (opInit (@RangeMaxPlus.isLeftCoDistributive_comp n)) ].

   (* IsRightCoDistributive *)
   destruct n as [|n];
   [ apply (opInit (@RangeMaxPlus.isRightCoDistributive1))
   | apply None].
   destruct n as [|n];
   [ apply None
   | apply (opInit (@RangeMaxPlus.isRightCoDistributive_comp n)) ].
*)

   (* PlusIdentityIsTimesAnnihilator *)
   apply None.
   apply (opInit (@RangeMaxPlus.plusIdentityIsTimesAnnihilator_comp n)).

   (* PlusAnnihilatorIsTimesIdentity *)
   apply None.
   apply (opInit (@RangeMaxPlus.plusAnnihilatorIsTimesIdentity_comp n)).

   (* IsRightStrictStable *)
   apply None.
   apply (opInit (@RangeMaxPlus.isRightStrictStable_comp n)).

   (* IsLeftStrictStable *)
   apply None.
   apply (opInit (@RangeMaxPlus.isLeftStrictStable_comp n)).

   (* IsRightCompEqCancel *)
   apply (opInit (@RangeMaxPlus.isRightCompEqCancel (1 + n))).
   apply None.

   (* IsLeftCompEqCancel *)
   apply (opInit (@RangeMaxPlus.isLeftCompEqCancel (1 + n))).
   apply None.

   (* IsRightCompCancel *)
   apply (opInit (@RangeMaxPlus.isRightCompCancel (1 + n))).
   apply None.

   (* IsLeftCompCancel *)
   apply (opInit (@RangeMaxPlus.isLeftCompCancel (1 + n))).
   apply None.

   (* LeftDiscrete *)
   apply None.
   apply (opInit (@RangeMaxPlus.leftDiscrete_comp n)).

   (* RightDiscrete *)
   apply None.
   apply (opInit (@RangeMaxPlus.rightDiscrete_comp n)).

   (* LeftComparable *)
   apply (opInit (@RangeMaxPlus.leftComparable (1 + n))).
   apply None.

   (* RightComparable *)
   apply (opInit (@RangeMaxPlus.rightComparable (1 + n))).
   apply None.

   (* LeftIncreasing *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* RightIncreasing *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* LeftStrictIncreasing *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* RightStrictIncreasing *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* IsRightTimesMapToIdConstantPlus *)
   apply None.
   apply (opInit (@RangeMaxPlus.isRightTimesMapToIdConstantPlus_comp n)).

   (* IsLeftTimesMapToIdConstantPlus *)
   apply None.
   apply (opInit (@RangeMaxPlus.isLeftTimesMapToIdConstantPlus_comp n)).

   (* PlusIdentityIsTimesLeftAnnihilator *)
   apply None.
   apply (opInit (@RangeMaxPlus.plusIdentityIsTimesLeftAnnihilator_comp n)).

   (* PlusIdentityIsTimesRightAnnihilator *)
   apply None.
   apply (opInit (@RangeMaxPlus.plusIdentityIsTimesRightAnnihilator_comp n)).
Defined.
