Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Semigroups.Lex.
Require Import Metarouting.Inference.Semigroups.Product.
Require Import Metarouting.Constructions.Bisemigroups.Product.

Definition prodBisemigroup_props {a} {b} (ap : bsProp a) (bp : bsProp b) : bsProp (prodBisemigroup a b).
   intros.
   apply (Build_bsProp (prodBisemigroup a b)
         (projPlusBSmgIso _ _ _ (prodSemigroup_props (bs_plus_sgprop _ ap) (bs_plus_sgprop _ bp)))
         (projTimesBSmgIso _ _ _ (prodSemigroup_props (bs_times_sgprop _ ap) (bs_times_sgprop _ bp))));
   hypPropSplit.

   (* IsLeftDistributive *)
   apply (opMap (@Product.isLeftDistributive a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.isLeftDistributive_comp a b)); opUnfoldBoolFormula; fail.

   (* IsRightDistributive *)
   apply (opMap (@Product.isRightDistributive a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.isRightDistributive_comp a b)); opUnfoldBoolFormula; fail.

(*
   (* IsLeftCoDistributive *)
   apply (opMap (@Product.isLeftCoDistributive a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.isLeftCoDistributive_comp a b)); opUnfoldBoolFormula; fail.

   (* IsRightCoDistributive *)
   apply (opMap (@Product.isRightCoDistributive a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.isRightCoDistributive_comp a b)); opUnfoldBoolFormula; fail.
*)
   (* PlusIdentityIsTimesAnnihilator *)
   apply (opMap (@Product.plusIdentityIsTimesAnnihilator a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.plusIdentityIsTimesAnnihilator_comp a b)); opUnfoldBoolFormula; fail.

   (* PlusAnnihilatorIsTimesIdentity *)
   apply (opMap (@Product.plusAnnihilatorIsTimesIdentity a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.plusAnnihilatorIsTimesIdentity_comp a b)); opUnfoldBoolFormula; fail.

   (* IsRightStrictStable *)
   apply (opMap (@Product.isRightStrictStable a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.isRightStrictStable_comp a b)); opUnfoldBoolFormula; fail.

   (* IsLeftStrictStable *)
   apply (opMap (@Product.isLeftStrictStable a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.isLeftStrictStable_comp a b)); opUnfoldBoolFormula; fail.

   (* IsRightCompEqCancel *)
   apply (opMap (@Product.isRightCompEqCancel a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.isRightCompEqCancel_comp a b)); opUnfoldBoolFormula; fail.

   (* IsLeftCompEqCancel *)
   apply (opMap (@Product.isLeftCompEqCancel a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.isLeftCompEqCancel_comp a b)); opUnfoldBoolFormula; fail.

   (* IsRightCompCancel *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* IsLeftCompCancel *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* LeftDiscrete *)
   apply (opMap (@Product.leftDiscrete a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.leftDiscrete_comp a b)); opUnfoldBoolFormula; fail.

   (* RightDiscrete *)
   apply (opMap (@Product.rightDiscrete a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.rightDiscrete_comp a b)); opUnfoldBoolFormula; fail.

   (* LeftComparable *)
   apply (opMap (@Product.leftComparable a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.leftComparable_comp a b)); opUnfoldBoolFormula; fail.

   (* RightComparable *)
   apply (opMap (@Product.rightComparable a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.rightComparable_comp a b)); opUnfoldBoolFormula; fail.

   (* LeftIncreasing *)
   apply (opMap (@Product.leftIncreasing a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.leftIncreasing_comp a b)); opUnfoldBoolFormula; fail.

   (* RightIncreasing *)
   apply (opMap (@Product.rightIncreasing a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.rightIncreasing_comp a b)); opUnfoldBoolFormula; fail.

   (* LeftStrictIncreasing *)
   apply (opMap (@Product.leftStrictIncreasing a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.leftStrictIncreasing_comp a b)); opUnfoldBoolFormula; fail.

   (* RightStrictIncreasing *)
   apply (opMap (@Product.rightStrictIncreasing a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.rightStrictIncreasing_comp a b)); opUnfoldBoolFormula; fail.

   (* IsRightTimesMapToIdConstantPlus *)
   apply (opMap (@Product.isRightTimesMapToIdConstantPlus a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.isRightTimesMapToIdConstantPlus_comp a b)); opUnfoldBoolFormula; fail.

   (* IsLeftTimesMapToIdConstantPlus *)
   apply (opMap (@Product.isLeftTimesMapToIdConstantPlus a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.isLeftTimesMapToIdConstantPlus_comp a b)); opUnfoldBoolFormula; fail.

   (* PlusIdentityIsTimesLeftAnnihilator *)
   apply (opMap (@Product.plusIdentityIsTimesLeftAnnihilator a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.plusIdentityIsTimesLeftAnnihilator_comp a b)); opUnfoldBoolFormula; fail.

   (* PlusIdentityIsTimesRightAnnihilator *)
   apply (opMap (@Product.plusIdentityIsTimesRightAnnihilator a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.plusIdentityIsTimesRightAnnihilator_comp a b)); opUnfoldBoolFormula; fail.
Defined.
